/* HallOfFames.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <ddraw.h>
#include <stdio.h>
#include "sprites.h"
#include "game.h"
#include "key.h"
#include "state.h"
#include "letters.h"
#include "sizes.h"
#include "_error.h"
#include "menu.h"


struct HallOfFamesItem
{
	int score;
	char name[14];
} typedef HallOfFamesItem;


BOOL g_bIsEnteringName = FALSE;
int g_count;
int g_rank;
HallOfFamesItem HallOfFames[10];


void LoadHallOfFames()
{
	HKEY  hKey;
	DWORD dwType = REG_BINARY;
	DWORD dwSize = sizeof(HallOfFames);
	
	//Charge HallOfFames  partir de la BDR
	
	if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_CURRENT_USER, "Software\\AK\\Bricks",
		                               NULL, KEY_READ, &hKey ) )
	{
		if( ERROR_SUCCESS == RegQueryValueEx( hKey, "HallOfFames",  0, &dwType, (BYTE*)&HallOfFames, &dwSize ) )
		{
			RegCloseKey( hKey );
			return;
		}
	}
	//Utilise les valeurs par dfaut
	for( int i = 0 ; i < 10 ; i++ )
	{
		strcpy(HallOfFames[i].name, "nobody" );
		HallOfFames[i].score = 0;
	}
}


void SaveHallOfFames()
{
	HKEY  hKey; 
	DWORD dwDisposition;
	DWORD dwType = REG_BINARY;
	DWORD dwSize = sizeof(HallOfFames);
	
	//Enregistre HallOfFames ds la BDR

	if( ERROR_SUCCESS == RegCreateKeyEx( HKEY_CURRENT_USER, "Software\\AK\\Bricks", 0, "",
		                                 REG_OPTION_NON_VOLATILE, 
										 KEY_ALL_ACCESS, NULL, &hKey,
										 &dwDisposition ) )
	{
		if( ERROR_SUCCESS == RegSetValueEx( hKey, "HallOfFames",  0, dwType, (BYTE*)&HallOfFames, dwSize ) )
		{
			RegFlushKey( hKey );
			RegCloseKey( hKey );
			return;
		}
	}
	Error( "Ne peut sauver HallOfFames" );
}


void InitHallOfFames( BOOL bEnterName )
{
	g_state = STATE_HALLOFFAMES;
	LoadHallOfFames();
	g_bIsEnteringName = FALSE;
	if( bEnterName )
	{
		g_count = 0;
		for( g_rank = 0 ; g_rank < 10 ; g_rank++ )
		{
			if( g_score > HallOfFames[g_rank].score )
			{
				memcpy( &HallOfFames[g_rank] + 1, &HallOfFames[g_rank], sizeof(HallOfFamesItem) * (10 - g_rank) );
				memset( HallOfFames[g_rank].name + 1, 0, 14 );
				HallOfFames[g_rank].name[0] = '_';
				HallOfFames[g_rank].score = g_score;
				g_bIsEnteringName = TRUE;
				break;
			}
		}
	}
}


void HallOfFamesPressKey( int key )
{
	if( g_bIsEnteringName )
	{
		toupper( key );
		if((( key >= 'A' )&&( key <= 'Z' ))||( key == ' '))
		{
			if( g_count < 13 )
			{
				HallOfFames[g_rank].name[g_count] = key;
				g_count++;
				HallOfFames[g_rank].name[g_count] = '_';
			}
		}
		else if( key == KEY_DEL )
		{
			if( g_count > 0 )
			{
				HallOfFames[g_rank].name[g_count] = 0;
				g_count--;
				HallOfFames[g_rank].name[g_count] = '_';
			}
		}
		else if( key == KEY_RETURN )
		{
			g_bIsEnteringName = FALSE;
			HallOfFames[g_rank].name[g_count++] = 0;
			SaveHallOfFames();
			InitGameLevel1();
			g_state = STATE_HALLOFFAMES;
		}
	}
	else
	{
		InitMenu();
	}
}


void DrawHallOfFames()
{
	char buf[7];
	
	DDPrint( HALLOFFAMES_TITLE_X, HALLOFFAMES_TITLE_Y, "Hall of Fames" );
	for( int i = 0 ; i < 10 ; i++ )
	{
		DDPrint( HALLOFFAMES_NAME_X, HALLOFFAMES_NAME_Y + LETTER_H * i, HallOfFames[i].name );
		_snprintf( buf, sizeof(buf), "%.6d", HallOfFames[i].score );
		DDPrint( HALLOFFAMES_SCORE_X, HALLOFFAMES_SCORE_Y + LETTER_H * i, buf );
	}
}
