/* config.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <windows.h>
#include "sound.h"
#include "game.h"
#include "dd.h"
#include "_error.h"
#include "dm.h"
#include "di.h"


//ConfigData: les donnes des options (pour sauvegarder les options)
struct ConfigData
{
	BOOL bFullScreen;
	BOOL bSounds;
	BOOL bMusic;
	BYTE bySpeed;
	BOOL bMouse;
} typedef ConfigData;


//LoadConfig : charge les options
void LoadConfig()
{
	ConfigData confdata;
	HKEY  hKey;
	DWORD dwType = REG_BINARY;
	DWORD dwSize = sizeof(ConfigData);
	
	//Charge la structure confdata
	
	if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_CURRENT_USER, "Software\\AK\\Bricks",
		                               0, KEY_READ, &hKey ) )
	{
		if( ERROR_SUCCESS == RegQueryValueEx( hKey, "Config",  0, &dwType, (BYTE*)&confdata, &dwSize ) )
		{
			RegCloseKey( hKey );

			//copie le contenu de confdata dans les variables globales
			g_bFullScreen = confdata.bFullScreen;
			g_bSounds = confdata.bSounds;
			g_bMusic = confdata.bMusic;
			g_speed = confdata.bySpeed;
			g_bMouse = confdata.bMouse;
			return;
		}
	}

	//Charge les valeurs par dfaut
	g_bFullScreen = FALSE;
	g_bSounds = TRUE;
	g_speed = 2;
	g_bMouse = TRUE;
}

//SaveConfig : sauvegarde les options de configuration
void SaveConfig()
{
	ConfigData confdata;
	HKEY  hKey; 
	DWORD dwDisposition;
	DWORD dwType = REG_BINARY;
	DWORD dwSize = sizeof(ConfigData);

	//Rempli la structure gamedata
	confdata.bFullScreen = g_bFullScreen;
	confdata.bSounds = g_bSounds;
	confdata.bMusic = g_bMusic;
	confdata.bySpeed = g_speed;
	confdata.bMouse = g_bMouse;
	
	//Enregistre cette structure
	
	if( ERROR_SUCCESS == RegCreateKeyEx( HKEY_CURRENT_USER, "Software\\AK\\Bricks", 0, "",
		                                 REG_OPTION_NON_VOLATILE, 
										 KEY_ALL_ACCESS, NULL, &hKey,
										 &dwDisposition ) )
	{
		if( ERROR_SUCCESS == RegSetValueEx( hKey, "Config",  0, dwType, (BYTE*)&confdata, dwSize ) )
		{
			RegFlushKey( hKey );
			RegCloseKey( hKey );
			return;
		}
	}
	Error("Ne peut sauver Config");
}
