/* dd.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <ddraw.h>
#include "ddutil.h"
#include "dd.h"
#include "main.h"
#include "_error.h"
#include "sprites.h"
#include "drawscreen.h"


LPDIRECTDRAW		g_lpDD			= NULL;						// L'objet DDraw
LPDIRECTDRAWSURFACE	g_lpDDSPrimary	= NULL;						// Surface primaire (=l'cran)
LPDIRECTDRAWSURFACE	g_lpDDSBack		= NULL;						// Back buffer (pour ne pas dessiner directement sur l'cran=>pas d'effet de scintillement
BOOL				g_bFullScreen	= FALSE;					// boolan indiquant si on est en mode plein cran ou non
RECT				g_rcSrc			= { 0, 0, RES_X, RES_Y };	// rectangle reprsantant l'cran


// Initialisation de DDraw
BOOL DDInit()
{
	HRESULT			hr;
	DDSURFACEDESC	ddsd;
	
	//Creation de l'objet ddraw
	hr = DirectDrawCreate( NULL, &g_lpDD, NULL );
	if(!DDCheck(hr, "Can't create direct draw object"))
		return FALSE;
	
	ZeroMemory( &ddsd, sizeof(ddsd) );
	ddsd.dwSize = sizeof(ddsd);
	
	if( g_bFullScreen )
	{
		DDSCAPS				ddscaps;

		//Configuration DDraw
		hr = g_lpDD->SetCooperativeLevel( g_hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );
		if(!DDCheck(hr, "Can't set cooperative level to full screen"))
			return FALSE;
		
		hr = g_lpDD->SetDisplayMode( RES_X, RES_Y, RES_BITS );
		if(!DDCheck(hr, "Can't set display mode to %i*%i*%i", RES_X, RES_Y, RES_BITS ))
			return FALSE;
		
		//Surface primaire
		ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
		ddsd.dwBackBufferCount = 1;
		hr = g_lpDD->CreateSurface( &ddsd, &g_lpDDSPrimary, NULL );
		if(!DDCheck(hr, "Can't create primary surface"))
			return FALSE;
		
		//Back buffer
		ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
		hr = g_lpDDSPrimary->GetAttachedSurface( &ddscaps, &g_lpDDSBack );
		if(!DDCheck(hr, "Can't create back buffer"))
			return FALSE;
	}
	else
	{
		LPDIRECTDRAWCLIPPER lpClipper = NULL;

		//Configuration DDraw
		hr = g_lpDD->SetCooperativeLevel( g_hWnd, DDSCL_NORMAL );
		if(!DDCheck(hr, "Can't set cooperative level to windowed mode"))
			return FALSE;

		//Surface primaire
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
		
		hr = g_lpDD->CreateSurface( &ddsd, &g_lpDDSPrimary, NULL );
		if(!DDCheck(hr, "Can't create primary surface"))
			return FALSE;

		//Back buffer
		ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
		ddsd.dwWidth = RES_X;
		ddsd.dwHeight = RES_Y;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		
		hr = g_lpDD->CreateSurface( &ddsd, &g_lpDDSBack, NULL );
		if(!DDCheck(hr, "Can't create back buffer"))
			return FALSE;

		//Clipper (permet d'associer la surface primaire  notre fentre)
		hr = g_lpDD->CreateClipper( 0, &lpClipper, NULL );
		if(!DDCheck(hr, "Can't create clipper"))
			return FALSE;
		
		hr = lpClipper->SetHWnd( 0, g_hWnd );
		if(!DDCheck(hr, "Can't assign window to clipper"))
			return FALSE;
		
		hr = g_lpDDSPrimary->SetClipper( lpClipper );
		if(!DDCheck(hr, "Can't attach clipper to the primary surface"))
			return FALSE;
		
		lpClipper->Release();
	}

	return TRUE;
}


// Ferme DDraw
void DDClose()
{
	// Remet la rsolution  celle d'origine
	if( g_bFullScreen && g_lpDD )
		g_lpDD->RestoreDisplayMode();
	// Dtruit les objets
	if( g_lpDDSPrimary )
		g_lpDDSPrimary->Release();
	if( g_lpDDSBack && !g_bFullScreen )
		g_lpDDSBack->Release();
	if( g_lpDD )
		g_lpDD->Release();
	g_lpDDSPrimary = NULL;
	g_lpDDSBack = NULL;
	g_lpDD = NULL;
}


// Fonction qui copie le contenu du back buffer sur l'cran
void DDFlip()
{
#ifdef _DEBUG		// En mode dbug, on vrifie la valeur retourne ...

	HRESULT hr;

	if( g_bFullScreen )
	{
		// Mode plein cran -> fonction Flip
		hr = g_lpDDSPrimary->Flip(g_lpDDSBack,DDFLIP_WAIT);
		DDCheck(hr, "DDFlip : Flip");
	}
	else
	{
		// Mode fentr -> on doit faire un Blt (=copie d'une surface sur une autre)
		hr = g_lpDDSPrimary->Blt(
			&g_rcWindow,	// Rectangle destination (g_lpDDSPrimary reprsente l'essemble de l'cran, on doit limiter le Blt  notre fenetre)
			g_lpDDSBack,	// Surface source
			&g_rcSrc,		// Rectangle source (0,0,640,480)
			DDBLT_WAIT,		// Paramtres
			NULL);
		DDCheck(hr, "DDFlip : Blt");
	}

#else				// ... Mais pas en release

	if( g_bFullScreen )
		g_lpDDSPrimary->Flip(g_lpDDSBack,DDFLIP_WAIT);
	else
		g_lpDDSPrimary->Blt(&g_rcWindow, g_lpDDSBack, &g_rcSrc, DDBLT_WAIT, NULL);

#endif //_DEBUG
}


// Vrifie si les surfaces n'ont pas t perdues (a arrive avec DDraw!)
BOOL DDCheckSurfaces()
{
	// Check the primary surface
	if (g_lpDDSPrimary) {
		if (g_lpDDSPrimary->IsLost() == DDERR_SURFACELOST)
		{
			g_lpDDSPrimary->Restore();
			return FALSE;
		}
	}
	return TRUE;
}


// Fonction qui dessine l'cran vers le back buffer puis affiche le back buffer sans oublier de vrifier les surfaces
void DDUpdate()
{
	DrawScreen();
	if(!DDCheckSurfaces())
		Error("DDUpdate : DDCheckSurfaces");
	DDFlip();
}


// Utilis si le jeu est en pause
void DDPaintPause()
{
	HRESULT hr = g_lpDDSBack->Blt( NULL, g_lpDDSPause, NULL, DDBLT_WAIT, NULL );
	DDCheck(hr, "DDPaintPause : Blt");
	DDFlip();
}
