/* ddutil.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <ddraw.h>
#include <stdio.h>
#include <stdarg.h>
#include "_error.h"
#include "dd.h"


// Retourne une chaine de caractres correspondant  une erreur
char *DDErrorString(HRESULT hr)
{
	switch (hr)
	{
	case DDERR_ALREADYINITIALIZED:           return "DDERR_ALREADYINITIALIZED";
	case DDERR_CANNOTATTACHSURFACE:          return "DDERR_CANNOTATTACHSURFACE";
	case DDERR_CANNOTDETACHSURFACE:          return "DDERR_CANNOTDETACHSURFACE";
	case DDERR_CURRENTLYNOTAVAIL:            return "DDERR_CURRENTLYNOTAVAIL";
	case DDERR_EXCEPTION:                    return "DDERR_EXCEPTION";
	case DDERR_GENERIC:                      return "DDERR_GENERIC";
	case DDERR_HEIGHTALIGN:                  return "DDERR_HEIGHTALIGN";
	case DDERR_INCOMPATIBLEPRIMARY:          return "DDERR_INCOMPATIBLEPRIMARY";
	case DDERR_INVALIDCAPS:                  return "DDERR_INVALIDCAPS";
	case DDERR_INVALIDCLIPLIST:              return "DDERR_INVALIDCLIPLIST";
	case DDERR_INVALIDMODE:                  return "DDERR_INVALIDMODE";
	case DDERR_INVALIDOBJECT:                return "DDERR_INVALIDOBJECT";
	case DDERR_INVALIDPARAMS:                return "DDERR_INVALIDPARAMS";
	case DDERR_INVALIDPIXELFORMAT:           return "DDERR_INVALIDPIXELFORMAT";
	case DDERR_INVALIDRECT:                  return "DDERR_INVALIDRECT";
	case DDERR_LOCKEDSURFACES:               return "DDERR_LOCKEDSURFACES";
	case DDERR_NO3D:                         return "DDERR_NO3D";
	case DDERR_NOALPHAHW:                    return "DDERR_NOALPHAHW";
	case DDERR_NOCLIPLIST:                   return "DDERR_NOCLIPLIST";
	case DDERR_NOCOLORCONVHW:                return "DDERR_NOCOLORCONVHW";
	case DDERR_NOCOOPERATIVELEVELSET:        return "DDERR_NOCOOPERATIVELEVELSET";
	case DDERR_NOCOLORKEY:                   return "DDERR_NOCOLORKEY";
	case DDERR_NOCOLORKEYHW:                 return "DDERR_NOCOLORKEYHW";
	case DDERR_NODIRECTDRAWSUPPORT:          return "DDERR_NODIRECTDRAWSUPPORT";
	case DDERR_NOEXCLUSIVEMODE:              return "DDERR_NOEXCLUSIVEMODE";
	case DDERR_NOFLIPHW:                     return "DDERR_NOFLIPHW";
	case DDERR_NOGDI:                        return "DDERR_NOGDI";
	case DDERR_NOMIRRORHW:                   return "DDERR_NOMIRRORHW";
	case DDERR_NOTFOUND:                     return "DDERR_NOTFOUND";
	case DDERR_NOOVERLAYHW:                  return "DDERR_NOOVERLAYHW";
	case DDERR_NORASTEROPHW:                 return "DDERR_NORASTEROPHW";
	case DDERR_NOROTATIONHW:                 return "DDERR_NOROTATIONHW";
	case DDERR_NOSTRETCHHW:                  return "DDERR_NOSTRETCHHW";
	case DDERR_NOT4BITCOLOR:                 return "DDERR_NOT4BITCOLOR";
	case DDERR_NOT4BITCOLORINDEX:            return "DDERR_NOT4BITCOLORINDEX";
	case DDERR_NOT8BITCOLOR:                 return "DDERR_NOT8BITCOLOR";
	case DDERR_NOTEXTUREHW:                  return "DDERR_NOTEXTUREHW";
	case DDERR_NOVSYNCHW:                    return "DDERR_NOVSYNCHW";
	case DDERR_NOZBUFFERHW:                  return "DDERR_NOZBUFFERHW";
	case DDERR_NOZOVERLAYHW:                 return "DDERR_NOZOVERLAYHW";
	case DDERR_OUTOFCAPS:                    return "DDERR_OUTOFCAPS";
	case DDERR_OUTOFMEMORY:                  return "DDERR_OUTOFMEMORY";
	case DDERR_OUTOFVIDEOMEMORY:             return "DDERR_OUTOFVIDEOMEMORY";
	case DDERR_OVERLAYCANTCLIP:              return "DDERR_OVERLAYCANTCLIP";
	case DDERR_OVERLAYCOLORKEYONLYONEACTIVE: return "DDERR_OVERLAYCOLORKEYONLYONEACTIVE";
	case DDERR_PALETTEBUSY:                  return "DDERR_PALETTEBUSY";
	case DDERR_COLORKEYNOTSET:               return "DDERR_COLORKEYNOTSET";
	case DDERR_SURFACEALREADYATTACHED:       return "DDERR_SURFACEALREADYATTACHED";
	case DDERR_SURFACEALREADYDEPENDENT:      return "DDERR_SURFACEALREADYDEPENDENT";
	case DDERR_SURFACEBUSY:                  return "DDERR_SURFACEBUSY";
	case DDERR_CANTLOCKSURFACE:              return "DDERR_CANTLOCKSURFACE";
	case DDERR_SURFACEISOBSCURED:            return "DDERR_SURFACEISOBSCURED";
	case DDERR_SURFACELOST:                  return "DDERR_SURFACELOST";
	case DDERR_SURFACENOTATTACHED:           return "DDERR_SURFACENOTATTACHED";
	case DDERR_TOOBIGHEIGHT:                 return "DDERR_TOOBIGHEIGHT";
	case DDERR_TOOBIGSIZE:                   return "DDERR_TOOBIGSIZE";
	case DDERR_TOOBIGWIDTH:                  return "DDERR_TOOBIGWIDTH";
	case DDERR_UNSUPPORTED:                  return "DDERR_UNSUPPORTED";
	case DDERR_UNSUPPORTEDFORMAT:            return "DDERR_UNSUPPORTEDFORMAT";
	case DDERR_UNSUPPORTEDMASK:              return "DDERR_UNSUPPORTEDMASK";
	case DDERR_VERTICALBLANKINPROGRESS:      return "DDERR_VERTICALBLANKINPROGRESS";
	case DDERR_WASSTILLDRAWING:              return "DDERR_WASSTILLDRAWING";
	case DDERR_XALIGN:                       return "DDERR_XALIGN";
	case DDERR_INVALIDDIRECTDRAWGUID:        return "DDERR_INVALIDDIRECTDRAWGUID";
	case DDERR_DIRECTDRAWALREADYCREATED:     return "DDERR_DIRECTDRAWALREADYCREATED";
	case DDERR_NODIRECTDRAWHW:               return "DDERR_NODIRECTDRAWHW";
	case DDERR_PRIMARYSURFACEALREADYEXISTS:  return "DDERR_PRIMARYSURFACEALREADYEXISTS";
	case DDERR_NOEMULATION:                  return "DDERR_NOEMULATION";
	case DDERR_REGIONTOOSMALL:               return "DDERR_REGIONTOOSMALL";
	case DDERR_CLIPPERISUSINGHWND:           return "DDERR_CLIPPERISUSINGHWND";
	case DDERR_NOCLIPPERATTACHED:            return "DDERR_NOCLIPPERATTACHED";
	case DDERR_NOHWND:                       return "DDERR_NOHWND";
	case DDERR_HWNDSUBCLASSED:               return "DDERR_HWNDSUBCLASSED";
	case DDERR_HWNDALREADYSET:               return "DDERR_HWNDALREADYSET";
	case DDERR_NOPALETTEATTACHED:            return "DDERR_NOPALETTEATTACHED";
	case DDERR_NOPALETTEHW:                  return "DDERR_NOPALETTEHW";
	case DDERR_BLTFASTCANTCLIP:              return "DDERR_BLTFASTCANTCLIP";
	case DDERR_NOBLTHW:                      return "DDERR_NOBLTHW";
	case DDERR_NODDROPSHW:                   return "DDERR_NODDROPSHW";
	case DDERR_OVERLAYNOTVISIBLE:            return "DDERR_OVERLAYNOTVISIBLE";
	case DDERR_NOOVERLAYDEST:                return "DDERR_NOOVERLAYDEST";
	case DDERR_INVALIDPOSITION:              return "DDERR_INVALIDPOSITION";
	case DDERR_NOTAOVERLAYSURFACE:           return "DDERR_NOTAOVERLAYSURFACE";
	case DDERR_EXCLUSIVEMODEALREADYSET:      return "DDERR_EXCLUSIVEMODEALREADYSET";
	case DDERR_NOTFLIPPABLE:                 return "DDERR_NOTFLIPPABLE";
	case DDERR_CANTDUPLICATE:                return "DDERR_CANTDUPLICATE";
	case DDERR_NOTLOCKED:                    return "DDERR_NOTLOCKED";
	case DDERR_CANTCREATEDC:                 return "DDERR_CANTCREATEDC";
	case DDERR_NODC:                         return "DDERR_NODC";
	case DDERR_WRONGMODE:                    return "DDERR_WRONGMODE";
	case DDERR_IMPLICITLYCREATED:            return "DDERR_IMPLICITLYCREATED";
	case DDERR_NOTPALETTIZED:                return "DDERR_NOTPALETTIZED";
	case DDERR_UNSUPPORTEDMODE:              return "DDERR_UNSUPPORTEDMODE";
	case DDERR_NOMIPMAPHW:                   return "DDERR_NOMIPMAPHW";
	case DDERR_INVALIDSURFACETYPE:           return "DDERR_INVALIDSURFACETYPE";
	case DDERR_DCALREADYCREATED:             return "DDERR_DCALREADYCREATED";
	case DDERR_CANTPAGELOCK:                 return "DDERR_CANTPAGELOCK";
	case DDERR_CANTPAGEUNLOCK:               return "DDERR_CANTPAGEUNLOCK";
	case DDERR_NOTPAGELOCKED:                return "DDERR_NOTPAGELOCKED";
	case DDERR_NOTINITIALIZED:               return "DDERR_NOTINITIALIZED";
	}
	return "Unknown Error";
}


// Vrifie un rsultat DirectDraw
BOOL DDCheck(HRESULT hr, const char *format, ... )
{
	if( FAILED(hr) )
	{
		char buf1[1024];
		char buf2[1024];
		va_list args;
		va_start(args, format);
		_vsnprintf(buf1, sizeof(buf1), format, args );
		va_end(args);
		_snprintf(buf2, sizeof(buf2), "DirectDraw ERROR : %s (%s)\n", buf1, DDErrorString(hr) );
		OutputDebugString(buf2);
		FILE *f = fopen("C:\\DEBUG.TXT","a+");
		if(f)
		{
			fprintf(f,"%s",buf2);
			fclose(f);
		}
		return FALSE;
	}
	return TRUE;
}


// Fonction DDColorMatch(): converti les couleurs RGB
DWORD DDColorMatch( LPDIRECTDRAWSURFACE lpDDS, COLORREF rgb )
{
	COLORREF				rgbT;
	HDC						hdc;
	DWORD					dw = CLR_INVALID;
	DDSURFACEDESC			ddsd;
    HRESULT					hr;

	if (rgb != CLR_INVALID && lpDDS->GetDC(&hdc) == DD_OK)
	{
		rgbT = GetPixel(hdc,0,0); // Sauvegarde de la valeur du Pixel actuel
		SetPixel(hdc,0,0,rgb);    // Met notre valeur
		lpDDS->ReleaseDC(hdc);
	}
	
	// On lock la surfrace pour lire la couleur convertie

	ddsd.dwSize = sizeof(ddsd);
	while ((hr = lpDDS->Lock(NULL, &ddsd,0,NULL)) == DDERR_WASSTILLDRAWING);
	if (hr == DD_OK)
	{
		dw=*(DWORD *) ddsd.lpSurface; //Obtiens le DWORD
		if (ddsd.ddpfPixelFormat.dwRGBBitCount <32)
			dw &= (1 << ddsd.ddpfPixelFormat.dwRGBBitCount) -1; //Le cacher en bbp
		lpDDS->Unlock(NULL);
	}
	//On remet la couleur qui y tait

	if (rgb!= CLR_INVALID && lpDDS->GetDC(&hdc)==DD_OK)
	{
		SetPixel(hdc,0,0,rgbT);
		lpDDS->ReleaseDC(hdc);
	}
	return dw;
}


// Fonction DDSetColorKey(): Met une color key  une surface, RGB.
//Prends en compte le pixel du haut  gauche.
HRESULT DDSetColorKey( LPDIRECTDRAWSURFACE lpDDS, COLORREF rgb )
{
	DDCOLORKEY	ddck;

	ddck.dwColorSpaceLowValue = DDColorMatch(lpDDS, rgb);
	ddck.dwColorSpaceHighValue = ddck.dwColorSpaceLowValue;
	return lpDDS->SetColorKey(DDCKEY_SRCBLT, &ddck);
}


/*
 *  DDLoadBitmap
 *
 *  create a DirectDrawSurface from a bitmap file or resource.
 *
 */
LPDIRECTDRAWSURFACE DDLoadBitmap( LPCSTR szBitmap, int width, int height)
{
	HBITMAP             hbm;
	BITMAP              bm;
	DDSURFACEDESC       ddsd;
	LPDIRECTDRAWSURFACE lpDDS = NULL;
	HDC					hdcImage = NULL;
	HDC					hdcSurf = NULL;
	HRESULT				hr;
	
    //
    //  try to load the bitmap as a resource, if that fails, try it as a file
    //
    hbm = (HBITMAP) LoadImage(GetModuleHandle(NULL), 
		szBitmap, 
		IMAGE_BITMAP, 
		width, 
		height, 
		LR_CREATEDIBSECTION);
	
    if (hbm == NULL)
        hbm = (HBITMAP)LoadImage(NULL, szBitmap, IMAGE_BITMAP, width, height, LR_LOADFROMFILE|LR_CREATEDIBSECTION);

    if (hbm == NULL)
	{
		Error("DDLoadBitmap : LoadImage : Can't load image");
        return NULL;
	}
	
    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);      // get size of bitmap
	
    //
    // create a DirectDrawSurface for this bitmap
    //
    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_CKSRCBLT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = bm.bmWidth;
    ddsd.dwHeight = bm.bmHeight;
	
    hr = g_lpDD->CreateSurface(&ddsd, &lpDDS, NULL);
	if(!DDCheck(hr, "DDLoadBitmap : Can't create surface"))
	{
		DeleteObject(hbm);
        return NULL;
	}
	
	// Cre un DC et y slectionne l'image
	hdcImage = CreateCompatibleDC(NULL);
	SelectObject(hdcImage, hbm);
	
	//Obtient un DC pour la surface
	hr = lpDDS->GetDC (&hdcSurf);
	if(!DDCheck(hr, "DDLoadBitmap : Can't get DC"))
	{
		DeleteDC(hdcImage);
		DeleteObject(hbm);
		lpDDS->Release();
		return NULL;
	}
	
	//BitBlt convertira le format si ncessaire.
	if (BitBlt (hdcSurf, 0,0,ddsd.dwWidth, ddsd.dwHeight, hdcImage, 0, 0, SRCCOPY) == FALSE)
	{
		Error("DDLoadBitmap : BitBlt");
		DeleteDC(hdcImage);
		DeleteObject(hbm);
		lpDDS->ReleaseDC(hdcSurf);
		lpDDS->Release();
		return NULL;
	}
	
	hr = DDSetColorKey(lpDDS, CLR_INVALID);
	if(!DDCheck(hr, "DDLoadBitmap : Can't set color key"))
	{
		DeleteDC(hdcImage);
		DeleteObject(hbm);
		lpDDS->ReleaseDC(hdcSurf);
		lpDDS->Release();
		return NULL;
	}

	DeleteDC(hdcImage);
	DeleteObject(hbm);
	lpDDS->ReleaseDC(hdcSurf);
	
    return lpDDS;
}
