/* di.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <dinput.h>
#include "diutil.h"
#include "key.h"
#include "_error.h"
#include "game.h"
#include "sizes.h"
#include "main.h"


#define KEYDOWN(name,key) (name[key] & 0x80) 


LPDIRECTINPUT7			g_lpDI = NULL;
LPDIRECTINPUTDEVICE7	g_lpDIDev = NULL;
HANDLE					g_hevtMouse = NULL;
BOOL					g_bMouse = FALSE;


void Mouse_OnButtonDown()
{
	g_bStartKeyPressed = TRUE;
}


void DIAcquire()
{
	if( g_lpDIDev )
	{
		OutputDebugString("Acquire\n");
		g_lpDIDev->Acquire();
	}
}


void DIUnacquire()
{
	if( g_lpDIDev )
	{
		OutputDebugString("Unacquire\n");
		g_lpDIDev->Unacquire();
	}
}


void DIOnMouseInput()
{
	int fDone = 0;
	
    while (!fDone)
	{
		DIDEVICEOBJECTDATA od;
		DWORD dwElements = 1;   // number of items to be retrieved
		
		HRESULT hr = g_lpDIDev->GetDeviceData(
                             sizeof(DIDEVICEOBJECTDATA),
                             &od,
                             &dwElements, 0);
		
		if (hr == DIERR_INPUTLOST)
		{
			DIAcquire();
			//PostMessage( g_hWnd, WM_SYNCACQUIRE, 0, 0L);
			break;
		}
		
        /* Unable to read data or no data available */
		if (FAILED(hr) || dwElements == 0)
		{
			break;
		}
		
		/* Look at the element to see what happened */
		
		switch (od.dwOfs)
		{
		
        /* DIMOFS_X: Mouse horizontal motion */
        case DIMOFS_X:

			g_raquetteX += od.dwData;
			if( g_raquetteX < 0 )
				g_raquetteX = 0;
			else if( g_raquetteX + RAQUETTE_W > RES_X )
				g_raquetteX = RES_X - RAQUETTE_W;
			
			break;
		
		/* DIMOFS_BUTTON0: Button 0 pressed or released */
		case DIMOFS_BUTTON0:
			if (od.dwData & 0x80) /* Button pressed */
			{
				fDone = 1;
				Mouse_OnButtonDown(); /* Go into button-down mode */
			}
			break; 
		}
    }
}


DWORD WINAPI DIMouseThread( LPVOID null )
{
	while( g_hevtMouse )
	{
		WaitForSingleObject( g_hevtMouse, INFINITE );
		DIOnMouseInput();
	}
	return 0;
}


BOOL DIStartMouseThread()
{
	DWORD dw;
	if(CreateThread( NULL, 0, &DIMouseThread, NULL, 0, &dw ) == NULL)
		return FALSE;
	return TRUE;
}


void DITerminateMouseThread()
{
}


BOOL InitMouse( HWND hWnd )
{
	#define DINPUT_BUFFERSIZE  16
	
	DIPROPDWORD dipdw =
	{
        // the header
		{
            sizeof(DIPROPDWORD),        // diph.dwSize
		    sizeof(DIPROPHEADER),       // diph.dwHeaderSize
            0,                          // diph.dwObj
		    DIPH_DEVICE,                // diph.dwHow
        },
        // the data
        DINPUT_BUFFERSIZE,              // dwData
    };
	
	// Create the DirectInput Mouse Device
	
	if(!DICheck(
		g_lpDI->CreateDeviceEx(	GUID_SysMouse,
								IID_IDirectInputDevice7,
								(void**)&g_lpDIDev,
								NULL),
		"Create the DirectInput Mouse Device"
		))
	{
		g_lpDI->Release();
		g_lpDI = NULL;
		return FALSE;
	}
	
	// Set the Mouse Data Format
	
	if(!DICheck(
		g_lpDIDev->SetDataFormat(&c_dfDIMouse),
		"Set the Mouse Data Format"
		))
	{
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
		return FALSE;
	}
	
	// Set the Mouse Behavior
	
	if(!DICheck(
		g_lpDIDev->SetCooperativeLevel(	hWnd,
										DISCL_EXCLUSIVE | DISCL_FOREGROUND),
		"Set the Mouse Behavior"
		))
	{
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
		return FALSE;
	}
	
	// Prepare for Buffered Input from the Mouse

	g_hevtMouse = CreateEvent(0, 0, 0, 0);
	
	if (g_hevtMouse == NULL)
	{
		Error("DInit : Mouse : CreateEvent");
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
	    return FALSE;
	}
	
	if(!DICheck(
		g_lpDIDev->SetEventNotification(g_hevtMouse),
		"Set mouse event notification"
		))
	{
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
		CloseHandle( g_hevtMouse );
		return FALSE;
	}
	
	if(!DICheck(
		g_lpDIDev->SetProperty(DIPROP_BUFFERSIZE, &dipdw.diph),
		"Set property"
		))
	{
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
		CloseHandle( g_hevtMouse );
		return FALSE;
	}
	
	if(!DIStartMouseThread())
	{
		Error("DIStartMouseThread");
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
		CloseHandle( g_hevtMouse );
		return FALSE;
	}

	return TRUE;
}


BOOL InitKeyboard( HWND hWnd )
{
	//Create the DirectInput Keyboard Device
	
	if(!DICheck(
		g_lpDI->CreateDeviceEx(	GUID_SysKeyboard,
								IID_IDirectInputDevice7,
								(void**)&g_lpDIDev,
								NULL),
		"Create DirectInput Keyboard Device"
		))
	{
		g_lpDI->Release();
		g_lpDI = NULL;
		return FALSE;
	}
	
	//Set the Keyboard Data Format
	
	if(!DICheck(
		g_lpDIDev->SetDataFormat(&c_dfDIKeyboard),
		"Set the Keyboard Data Format"
		))
	{
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
		return FALSE;
	}
	
	// Set the cooperative level
	
	if(!DICheck(
		g_lpDIDev->SetCooperativeLevel( hWnd,
										DISCL_FOREGROUND | DISCL_NONEXCLUSIVE),
		"Set the cooperative level"
		))
	{
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
		return FALSE;
	}
	
	//Gain Access to the Keyboard
	
	if(!DICheck(
		g_lpDIDev->Acquire(),
		"Gain Access to the Keyboard"
		))
	{
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
		g_lpDI->Release();
		g_lpDI = NULL;
		return FALSE;
	}
	
	return TRUE;
}


BOOL DIInit( HINSTANCE h, HWND hWnd, BOOL bMouse /*Mouse or keyboard?*/ )
{
	g_bMouse = bMouse;
	
	//Create the DirectInputObject
	
	if(!DICheck(
		DirectInputCreateEx(h,
							DIRECTINPUT_VERSION,
							IID_IDirectInput7,
							(void**)&g_lpDI,
							NULL),
		"Create DirectInputObject"
		))
		return FALSE;
	
	if( bMouse )
		return InitMouse( hWnd );
	else
		return InitKeyboard( hWnd );
	
	return FALSE;
}


void CloseDevice()
{
	if (g_lpDIDev)
	{
		if (g_bMouse)
			DITerminateMouseThread();
		/* Always unacquire device before calling Release(). */
		g_lpDIDev->Unacquire();
		g_lpDIDev->Release();
		g_lpDIDev = NULL;
	}
}


void DIClose() 
{
	if (g_lpDI)
	{
		CloseDevice();
		g_lpDI->Release();
		g_lpDI = NULL;
	}
}


void WINAPI ProcessKBInput()
{
	char buffer[256];
	
    if(FAILED(
		g_lpDIDev->GetDeviceState( sizeof(buffer), (LPVOID)&buffer )
		))
		return;
	
	g_byInput = 0;

    // Move right or left 
    if (KEYDOWN(buffer, DIK_RIGHT))
	{
		g_byInput |= KEY_RIGHT;
	}
    else if(KEYDOWN(buffer, DIK_LEFT))
	{
		g_byInput |= KEY_LEFT;
	}
}


BOOL DISwitchControlMode()
{
	g_bMouse = !g_bMouse;

	if( g_bMouse )
	{
		/** Close Keyboard and init mouse **/
		
		//Close prev device
		CloseDevice();
		
		//Create and configure new device
		return InitMouse( g_hWnd );
	}
	else
	{
		/** Close mouse and init keyboard **/
		
		//Close prev device
		CloseDevice();
		
		//Create and configure new device
		return InitKeyboard( g_hWnd );
	}

	return FALSE;
}