/* diutil.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <dinput.h>
#include <stdio.h>
#include <stdarg.h>


char* DIErrorString( HRESULT hr )
{
	switch( hr )
	{
	case DIERR_OLDDIRECTINPUTVERSION:	return "DIERR_OLDDIRECTINPUTVERSION";
	case DIERR_BETADIRECTINPUTVERSION:	return "DIERR_BETADIRECTINPUTVERSION";
	case DIERR_BADDRIVERVER:			return "DIERR_BADDRIVERVER";
	case DIERR_DEVICENOTREG:			return "DIERR_DEVICENOTREG";
	case DIERR_NOTFOUND:				return "DIERR_NOTFOUND";
	case DIERR_INVALIDPARAM:			return "DIERR_INVALIDPARAM";
	case DIERR_NOINTERFACE:				return "DIERR_NOINTERFACE";
	case DIERR_GENERIC:					return "DIERR_GENERIC";
	case DIERR_OUTOFMEMORY:				return "DIERR_OUTOFMEMORY";
	case DIERR_UNSUPPORTED:				return "DIERR_UNSUPPORTED";
	case DIERR_NOTINITIALIZED:			return "DIERR_NOTINITIALIZED";
	case DIERR_ALREADYINITIALIZED:		return "DIERR_ALREADYINITIALIZED";
	case DIERR_NOAGGREGATION:			return "DIERR_NOAGGREGATION";
	case DIERR_OTHERAPPHASPRIO:			return "DIERR_OTHERAPPHASPRIO";
	case DIERR_INPUTLOST:				return "DIERR_INPUTLOST";
	case DIERR_ACQUIRED:				return "DIERR_ACQUIRED";
	case DIERR_NOTACQUIRED:				return "DIERR_NOTACQUIRED";
	case E_PENDING:						return "E_PENDING";
	case DIERR_INSUFFICIENTPRIVS:		return "DIERR_INSUFFICIENTPRIVS";
	case DIERR_DEVICEFULL:				return "DIERR_DEVICEFULL";
	case DIERR_MOREDATA:				return "DIERR_MOREDATA";
	case DIERR_NOTDOWNLOADED:			return "DIERR_NOTDOWNLOADED";
	case DIERR_HASEFFECTS:				return "DIERR_HASEFFECTS";
	case DIERR_NOTEXCLUSIVEACQUIRED:	return "DIERR_NOTEXCLUSIVEACQUIRED";
	case DIERR_INCOMPLETEEFFECT:		return "DIERR_INCOMPLETEEFFECT";
	case DIERR_NOTBUFFERED:				return "DIERR_NOTBUFFERED";
	case DIERR_EFFECTPLAYING:			return "DIERR_EFFECTPLAYING";
	case DIERR_UNPLUGGED:				return "DIERR_UNPLUGGED";
	case DIERR_REPORTFULL:				return "DIERR_REPORTFULL";
	}
	return "Unknown error";
}


BOOL DICheck( HRESULT hr, const char *format, ... )
{
	if( FAILED(hr) )
	{
		char buf1[1024];
		char buf2[1024];
		va_list args;
		FILE *f;

		va_start(args, format);
		_vsnprintf(buf1, sizeof(buf1), format, args );
		va_end(args);
		_snprintf(buf2, sizeof(buf2), "DirectInput ERROR : %s (%s)\n", buf1, DIErrorString(hr) );
		OutputDebugString(buf2);
		f = fopen("C:\\DEBUG.TXT","a+");
		if(f)
		{
			fprintf(f,"%s",buf2);
			fclose(f);
		}
		return FALSE;
	}
	return TRUE;
}
