/* dm.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <dmusicc.h>
#include <dmusici.h>
#include "dmutil.h"
#include "resource.h"
#include "_error.h"
#include "sound.h"
#include "main.h"
#include "game.h"
#include "state.h"


IDirectMusicPerformance* g_pDMPerf = NULL;
IDirectMusicLoader* g_pDMLoader = NULL;
IDirectMusicSegment* g_pDMSegment = NULL;
MUSIC_TIME g_mtCur;
BOOL g_bMusic = TRUE;


BOOL DMInit( LPDIRECTSOUND lpDirectSound, HWND hWnd )
{
	if( FAILED( CoInitialize(NULL) ) )
	{
		return FALSE;
	}

	g_pDMPerf = DMCreatePerformance();
	if( g_pDMPerf == NULL )
	{
		return FALSE;
	}

	if( FAILED( g_pDMPerf->Init( NULL, lpDirectSound, hWnd ) ) )
	{
		return FALSE;
	}

	if( FAILED( g_pDMPerf->AddPort( NULL ) ) )
	{
		return FALSE;
	}

	g_pDMLoader = DMCreateLoader();
	if( g_pDMLoader == NULL )
	{
		return FALSE;
	}

	return TRUE;
}


void DMClose()
{
	if( g_pDMLoader )
	{
		// Release the loader object.
		g_pDMLoader->Release();
		
		g_pDMLoader = NULL;
	}
	
	if( g_pDMPerf )
	{
		// If there is any music playing, stop it. This is 
		// not really necessary, because the music will stop when
		// the instruments are unloaded or the performance is
		// closed down.
		g_pDMPerf->Stop( NULL, NULL, 0, 0 );
		
		if( g_pDMSegment )
		{
			// Unload instruments : this will cause silence.
			// CloseDown unloads all instruments, so this call is also not
			// strictly necessary.
			g_pDMSegment->SetParam(GUID_Unload, (DWORD)-1, 0, 0, (void*)g_pDMPerf);
			
			// Release the segment.
		    g_pDMSegment->Release();
			
			g_pDMSegment = NULL;
		}
				
		// CloseDown and Release the performance object.
		g_pDMPerf->CloseDown();
		g_pDMPerf->Release();
		
		g_pDMPerf = NULL;		
	}
	// Release COM.
	CoUninitialize();
}


void MusicLoad( int level )
{
	if( g_bMusic )
	{
		OutputDebugString("MusicLoad\n");
		DMCheck( g_pDMPerf->Stop( g_pDMSegment, NULL, 0, 0 ), "MusicLoad: Stop" );
		DMUnload( &g_pDMSegment );
		if(( level < 1 )||( level > 8 ))
			return;
		int res[8] = { IDR_FUNK, IDR_ALLATURKA, IDR_CLUB, IDR_INSTALL, IDR_FURELISE, IDR_FUNK, IDR_CLUB, IDR_IWILLSURVIE };
		g_pDMSegment = DMLoad( MAKEINTRESOURCE(res[level-1]) );
		g_pDMSegment->SetRepeats( INFINITE );
		g_mtCur = 0;
	}
}


void MusicPause( BOOL bPause )
{
	OutputDebugString("MusicPause:");
	if( bPause )
	{
		if( g_pDMSegment && g_pDMPerf )
		{
			OutputDebugString("Pause\n");
			if( g_mtCur != 0 )
			{
				//OutputDebugString("GetTime\n");
				DMCheck( g_pDMPerf->GetTime( NULL, &g_mtCur ), "GetTime" );
			}
			//Error("mtcur=%i",g_mtCur);
			DMCheck( g_pDMPerf->Stop( g_pDMSegment, NULL, 0, 0 ), "Stop" );
		}
	}
	else
	{
		if( g_pDMSegment && g_pDMPerf )
		{
			OutputDebugString("Unpause\n");
			//Error("mtcur=%i",g_mtCur);
			DMCheck( g_pDMSegment->SetStartPoint( g_mtCur ), "SetStartPoint" );
			DMCheck( g_pDMPerf->PlaySegment( g_pDMSegment, 0, 0, NULL ), "PlaySegment" );
			g_mtCur = 1;
		}
	}
}


void SetMusic( BOOL bMusic )
{
	OutputDebugString("SetMusic\n");
	if( bMusic )
	{
		DMInit( g_lpDS, g_hWnd );
		MusicLoad( g_level );
		if( g_state == STATE_GAME )
			MusicPause( FALSE );
	}
	else
	{
		if( g_pDMPerf )
		{
			DMCheck( g_pDMPerf->Stop( g_pDMSegment, NULL, 0, 0 ), "SetMusic: Stop" );
		}
		DMUnload( &g_pDMSegment );
		DMClose();
	}
}