/* dmutil.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <dmusicc.h>
#include <dmusici.h>
#include <direct.h>
#include <wchar.h>
#include <stdarg.h>
#include <stdio.h>
#include "dm.h"
#include "strtowc.h"


#define MULTI_TO_WIDE( x,y )  MultiByteToWideChar( CP_ACP, \
        MB_PRECOMPOSED, y, -1, x, _MAX_PATH );

char* DMErrorString( HRESULT hr )
{
	switch( hr )
	{
	case E_OUTOFMEMORY:
		return("E_OUTOFMEMORY");
	case E_POINTER:
		return("E_POINTER");
	case DMUS_E_NO_MASTER_CLOCK:
		return("DMUS_E_NO_MASTER_CLOCK");
	case DMUS_E_SEGMENT_INIT_FAILED:
		return("DMUS_E_SEGMENT_INIT_FAILED");
	case DMUS_E_TIME_PAST:
		return("DMUS_E_TIME_PAST");
	}
	return "Unknown error";
}


BOOL DMCheck( HRESULT hr, const char *format, ... )
{
	if( FAILED(hr) )
	{
		char buf1[1024];
		char buf2[1024];
		va_list args;
		va_start(args, format);
		_vsnprintf(buf1, sizeof(buf1), format, args );
		va_end(args);
		_snprintf(buf2, sizeof(buf2), "DirectMusic ERROR : %s (%s)\n", buf1, DMErrorString(hr) );
		OutputDebugString(buf2);
		FILE *f = fopen("C:\\DEBUG.TXT","a+");
		if(f)
		{
			fprintf(f,"%s",buf2);
			fclose(f);
		}
		return FALSE;
	}
	return TRUE;
}


IDirectMusicPerformance* DMCreatePerformance(void)
{
	IDirectMusicPerformance* pPerf;
	
	if (FAILED(CoCreateInstance(
			CLSID_DirectMusicPerformance,
			NULL,
			CLSCTX_INPROC, 
			IID_IDirectMusicPerformance2,
			(void**)&pPerf
		)))
	{
		pPerf = NULL;
	}

	return pPerf;
}


IDirectMusicLoader* DMCreateLoader(void)
{
	IDirectMusicLoader* pLoader;
	
	if (FAILED(CoCreateInstance(
			CLSID_DirectMusicLoader,
			NULL,
			CLSCTX_INPROC, 
			IID_IDirectMusicLoader,
			(void**)&pLoader
		)))
	{
		pLoader = NULL;
	}

	return pLoader;
}


IDirectMusicSegment* LoadMIDISegmentFromFile( IDirectMusicPerformance* pPerf,
											 IDirectMusicLoader* pLoader,
											 LPSTR lpMidiFileName )
{
	DMUS_OBJECTDESC ObjDesc;
	IDirectMusicSegment* pSegment = NULL;
	
	char szDir[_MAX_PATH];
	WCHAR wszDir[_MAX_PATH];
	
	if(_getcwd( szDir, _MAX_PATH ) == NULL)
	{
		return NULL;
	}
	
	MULTI_TO_WIDE(wszDir, szDir);
	HRESULT hr = pLoader->SetSearchDirectory(GUID_DirectMusicAllTypes, wszDir, FALSE);
	if (FAILED(hr)) 
	{
		return NULL;
	}
	
	ObjDesc.guidClass = CLSID_DirectMusicSegment;
	ObjDesc.dwSize = sizeof(DMUS_OBJECTDESC);
//	wcscpy( ObjDesc.wszFileName, L"club.mid");
	strtowc( ObjDesc.wszFileName, lpMidiFileName );
	ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_FILENAME;
	
	pLoader->GetObject(&ObjDesc,
		IID_IDirectMusicSegment2, (void**) &pSegment);
	
	pSegment->SetParam(GUID_StandardMIDIFile,
		(DWORD)-1, 0, 0, (void*)pPerf);
	
	pSegment->SetParam(GUID_Download, (DWORD)-1, 0, 0, (void*)pPerf);
	
	return pSegment;
}


IDirectMusicSegment* LoadMIDISegmentFromResource( IDirectMusicPerformance* pPerf,
												 IDirectMusicLoader* pLoader,
												 LPSTR lpName )
{
	DMUS_OBJECTDESC ObjDesc; 
	IDirectMusicSegment* pSegment = NULL;
	
	//Get data from resource
	HINSTANCE h = GetModuleHandle(NULL);
	HRSRC hResInfo = NULL;		// informations sur la ressource
	HGLOBAL hResData = NULL;	// handle des donnes de la ressource
	BYTE *pbData = NULL;		// donnes de la ressource
	
	// Trouve la ressource
	hResInfo = FindResource( h, lpName, "MIDI" );
	if( hResInfo == NULL )
	{
		return NULL;
	}
	
	// Charge la ressource
	hResData = LoadResource( h, hResInfo );
	if( hResData == NULL )
	{
		return NULL;
	}
	
	// Obtient un pointeur vers le donnes de la ressource
	pbData = (BYTE*)LockResource( hResData );
	if( pbData == NULL )
	{
		return NULL;
	}
	
	//Load data
    ObjDesc.guidClass = CLSID_DirectMusicSegment;
    ObjDesc.dwSize = sizeof(DMUS_OBJECTDESC);
    ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_MEMORY;
	ObjDesc.pbMemData = pbData;
	ObjDesc.llMemLength = SizeofResource( h, hResInfo );
	
    pLoader->GetObject(&ObjDesc,
            IID_IDirectMusicSegment2, (void**) &pSegment);
	
    pSegment->SetParam(GUID_StandardMIDIFile,
            (DWORD)-1, 0, 0, (void*)pPerf);
	
    pSegment->SetParam(GUID_Download, (DWORD)-1, 0, 0, (void*)pPerf);
	
    return pSegment;
}


IDirectMusicSegment* LoadMIDISegment( IDirectMusicPerformance* pPerf,
									 IDirectMusicLoader* pLoader,
									 LPSTR lpMidiFileOrResourceName )
{
	IDirectMusicSegment* sgt = NULL;
	
	sgt = LoadMIDISegmentFromResource( pPerf, pLoader, lpMidiFileOrResourceName );
	if( sgt == NULL )
	{
		return LoadMIDISegmentFromFile( pPerf, pLoader, lpMidiFileOrResourceName );
	}

	return sgt;
}


IDirectMusicSegment* DMLoad( LPSTR lpName )
{
	return LoadMIDISegment( g_pDMPerf, g_pDMLoader, lpName );
}


void DMUnload( IDirectMusicSegment** ppSegment )
{
	if( *ppSegment )
	{
		// Release the segment.
		(*ppSegment)->Release();
		
		*ppSegment = NULL;
	}
}

/*
BOOL DMPlay( IDirectMusicSegment* pSegment )
{
	if (pSegment)
	{
		pSegment->SetRepeats( INFINITE );
		g_pDMPerf->PlaySegment( pSegment, 0, 0, NULL );
	}
	
	return TRUE;
}*/


void DMStop( IDirectMusicPerformance* pPerf )
{
	if( pPerf )
	{
		pPerf->Stop(NULL, NULL, 0, 0);
	}
}
