/* drawscreen.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <ddraw.h>
#include <stdio.h>
#include "dd.h"
#include "ddutil.h"
#include "sprites.h"
#include "game.h"
#include "sizes.h"
#include "state.h"
#include "menu.h"
#include "HallOfFames.h"
#include "GameOver.h"


// dessine la balle
void DrawBall()
{
	RECT rcDest;
	HRESULT hr;
	
	SetRect( &rcDest, g_ballX, g_ballY, g_ballX + BALL_W, g_ballY + BALL_H );
	hr = g_lpDDSBack->Blt(
			&rcDest,
			g_lpDDSBall,
			NULL,
			DDBLT_WAIT,
			NULL );
	DDCheck(hr, "DrawBall : Blt g_lpDDSBall");
}


// dessine les briques
void DrawBriks()
{
	int i, j, b;
	RECT rcDest;
	HRESULT hr;

	for( i = 0 ; i < 18 ; i++ )
		for( j = 0 ; j < 18 ; j++ )
		{
			b = briks[i][j];
			if( b != 0 )
			{
				b--;
				SetRect( &rcDest, i * BRIK_W + BRIK_X, j * BRIK_H + BRIK_Y, (i+1) * BRIK_W + BRIK_X, (j+1) * BRIK_H + BRIK_Y );
				hr = g_lpDDSBack->Blt(
						&rcDest,
						g_lpDDSBrik[b],
						NULL,
						DDBLT_WAIT,
						NULL );
				DDCheck(hr, "DrawBriks : Blt g_lpDDSBrik[%i]", b);
			}
		}
}


// affiche le score et le niveau
void DrawScore()
{
	HRESULT hr;
	RECT rcDest;
	char n;
	char buf[7];
	
	//Dcors
	SetRect( &rcDest, 0, 0, DECOR_W, DECOR_H );
	hr = g_lpDDSBack->Blt(
			&rcDest,
			g_lpDDSScore,
			NULL,
			DDBLT_WAIT,
			NULL );
	DDCheck(hr, "DrawScore : Blt g_lpDDSScore");
	
	//Score
	_snprintf( buf, 7, "%.6d", g_score );
	for( int i = 0 ; i < 6 ; i++ )
	{
		n = buf[i] - 48;
		SetRect( &rcDest, i * NUMBER_W + SCORE_X, SCORE_Y, (i+1) * NUMBER_W + SCORE_X, SCORE_Y + NUMBER_H );
		hr = g_lpDDSBack->Blt(
				&rcDest,
				g_lpDDSNumber[n],
				NULL,
				DDBLT_WAIT,
				NULL );
		DDCheck(hr, "DrawScore : Blt g_lpDDSNumber[%i]", n);
	}
	
	//Level
	SetRect( &rcDest, LEVEL_X, LEVEL_Y, LEVEL_X + NUMBER_W, LEVEL_Y + NUMBER_H );
	hr = g_lpDDSBack->Blt(
			&rcDest,
			g_lpDDSNumber[g_level],
			NULL,
			DDBLT_WAIT,
			NULL );
	DDCheck(hr, "DrawScore : Blt g_lpDDSNumber[%i]", g_level);
}


// dessine la raquette
void DrawRaquette()
{
	HRESULT hr;
	RECT rcDest;

	rcDest.top = RAQUETTE_Y;
	rcDest.left = g_raquetteX;
	rcDest.bottom = RAQUETTE_Y + RAQUETTE_H;
	rcDest.right = g_raquetteX + RAQUETTE_W;
	
	hr = g_lpDDSBack->Blt(
						&rcDest,
						g_lpDDSRaquette,
						NULL,
						DDBLT_WAIT,
						NULL );
	
	DDCheck(hr, "DrawRaquette : Blt g_lpDDSRaquette");
}


// met l'cran tout noir
void ClearScreen()
{
	HRESULT		hr;			//The return value of the function
	DDBLTFX		ddbltfx;	// Direct Draw blit
	
	//set the size and color
	ddbltfx.dwSize = sizeof( ddbltfx );
	ddbltfx.dwFillColor = 0;
	
	//Blit the surface and put the return value in ddrval
	hr = g_lpDDSBack->Blt(
						NULL,                 
						NULL,          
						NULL, 
						DDBLT_COLORFILL | DDBLT_WAIT,
						&ddbltfx );
	
	DDCheck(hr, "ClearScreen : Blt");
}


// dessine les vies restantes
void DrawLives()
{
	HRESULT	hr;
	RECT	rcDest;
	
	for( int i = 0 ; i < g_lives ; i++ )
	{
		SetRect( &rcDest, i * LIFE_OFFSET + LIFE_X, LIFE_Y, i * LIFE_OFFSET + LIFE_X + LIFE_W, LIFE_Y + LIFE_H );
		hr = g_lpDDSBack->Blt(
							&rcDest,
							g_lpDDSLife,
							NULL,
							DDBLT_WAIT,
							NULL );
		
		DDCheck(hr, "DrawLives : Blt g_lpDDSLife");
	}
}


//dessine le titre 'Bricks!'
void DrawTitle()
{
	HRESULT hr;
	RECT rcDest;
	
	SetRect( &rcDest, TITLE_X, TITLE_Y, TITLE_X + TITLE_W, TITLE_Y + TITLE_H );
	
	hr = g_lpDDSBack->Blt(
						&rcDest,
						g_lpDDSBricks,
						NULL,
						DDBLT_WAIT,
						NULL );
	
	DDCheck(hr, "DrawTitle : Blt g_lpDDSBricks");
}


// dessine tout l'cran
void DrawScreen()
{
	switch( g_state )
	{
	case STATE_GAME:
		ClearScreen();
		DrawScore();
		DrawLives();
		DrawBriks();
		DrawRaquette();
		DrawBall();
		break;
	case STATE_MENU:
		ClearScreen();
		DrawTitle();
		DrawMenu();
		break;
	case STATE_HALLOFFAMES:
		ClearScreen();
		DrawTitle();
		DrawHallOfFames();
		break;
	case STATE_GAMEOVER:
		DrawGameOver();
	}
}
