/* dsutil.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <dsound.h>
#include <stdarg.h>
#include <stdio.h>
#include "sound.h"
#include "wave.h"
#include "_error.h"


// Vrifie un rsultat retourn par une fonction DirectSound
BOOL DSCheck(HRESULT hr, const char *format, ... )
{
	if( hr == DS_OK ) return TRUE;
	else
	{
		char buf[1024];
		va_list args;
		va_start(args, format);
		_vsnprintf(buf, sizeof(buf), format, args);
		va_end(args);
		OutputDebugString("DirectSound ERROR : ");
		OutputDebugString(buf);
		OutputDebugString(" (");
		switch(hr)
		{
		case DSERR_ACCESSDENIED:		OutputDebugString("DSERR_ACCESSDENIED");		break;
		case DSERR_ALLOCATED:			OutputDebugString("DSERR_ALLOCATED");			break;
		case DSERR_ALREADYINITIALIZED:	OutputDebugString("DSERR_ALREADYINITIALIZED");	break;
		case DSERR_BADFORMAT:			OutputDebugString("DSERR_BADFORMAT");			break;
		case DSERR_BUFFERLOST:			OutputDebugString("DSERR_BUFFERLOST");			break;
		case DSERR_CONTROLUNAVAIL:		OutputDebugString("DSERR_CONTROLUNAVAIL");		break;
		case DSERR_GENERIC:				OutputDebugString("DSERR_GENERIC");				break;
		case DSERR_INVALIDCALL:			OutputDebugString("DSERR_INVALIDCALL");			break;
		case DSERR_INVALIDPARAM:		OutputDebugString("DSERR_INVALIDPARAM");		break;
		case DSERR_NOAGGREGATION:		OutputDebugString("DSERR_NOAGGREGATION");		break;
		case DSERR_NODRIVER:			OutputDebugString("DSERR_NODRIVER");			break;
		case DSERR_NOINTERFACE:			OutputDebugString("DSERR_NOINTERFACE");			break;
		case DSERR_OTHERAPPHASPRIO:		OutputDebugString("DSERR_OTHERAPPHASPRIO");		break;
		case DSERR_OUTOFMEMORY:			OutputDebugString("DSERR_OUTOFMEMORY");			break;
		case DSERR_PRIOLEVELNEEDED:		OutputDebugString("DSERR_PRIOLEVELNEEDED");		break;
		case DSERR_UNINITIALIZED:		OutputDebugString("DSERR_UNINITIALIZED");		break;
		case DSERR_UNSUPPORTED:			OutputDebugString("DSERR_UNSUPPORTED");			break;
		default:
			OutputDebugString("Unknown error");
		}
		OutputDebugString(")\n");
	}
	return FALSE;
}


// Charge un fichier .WAV  partir d'un fichier ou d'une ressource qui se trouve dans l'excutable. Retourne un buffer DSound
LPDIRECTSOUNDBUFFER DSLoadWave( LPSTR lpName )
{
	HRESULT				hr;
	DSBUFFERDESC		dsbdesc;
	LPDIRECTSOUNDBUFFER lpDSB = NULL;
	WAVEFORMATEX		*pwfx;				// Wave format info.
	HMMIO				hmmio;				// File handle.
	MMCKINFO			mmckinfo;			// Chunk info.
	MMCKINFO			mmckinfoParent;		// Parent chunk info.
	LPVOID				lpvAudio1;
	DWORD				dwBytes1;
	UINT				cbBytesRead;		//Number of bytes read
	
	//Open the file
	if ( WaveOpenFile( lpName, &hmmio, &pwfx, &mmckinfoParent ) != 0 )
	{
		Error("DSLoadWave : WaveOpenFile");
		return NULL;
	}
	
	//Read the file
	if ( WaveStartDataRead( &hmmio, &mmckinfo, &mmckinfoParent ) != 0 )
	{
		Error("DSLoadWave : WaveStartDataRead");
		GlobalFree(pwfx);
		return NULL;
	}
	
	//Create the buffer
	ZeroMemory( &dsbdesc, sizeof(DSBUFFERDESC) );
	dsbdesc.dwSize = sizeof(DSBUFFERDESC);
	dsbdesc.dwFlags = DSBCAPS_STATIC;
	dsbdesc.dwBufferBytes = mmckinfo.cksize;  
	dsbdesc.lpwfxFormat = pwfx; 
	
	hr = g_lpDS->CreateSoundBuffer( &dsbdesc, &lpDSB, NULL );
	if(!DSCheck(hr, "DSLoadWave : CreateBuffer"))
	{
		WaveCloseReadFile( &hmmio, &pwfx );
		return NULL;
	}
	
	//Lock the buffer
	hr = lpDSB->Lock(
		0,						// Offset of lock start.
		0,						// Size of lock; ignored in this case.
		&lpvAudio1,				// Address of lock start.
		&dwBytes1,				// Number of bytes locked.
		NULL,					// Address of wraparound start.
		NULL,					// Number of wraparound bytes.
		DSBLOCK_ENTIREBUFFER	// Flag.
		);
	if(!DSCheck(hr, "LoadSound : Lock"))
	{
		// Error handling.
		WaveCloseReadFile( &hmmio, &pwfx );
		return NULL;
	}
	
	
	if ( WaveReadFile( hmmio,	// File handle.
		dwBytes1,				// Number of bytes to read.
		( BYTE * )lpvAudio1,	// Destination.
		&mmckinfo,				// File chunk info.
		&cbBytesRead ) )		// Actual number of bytes read.
	{
		// Handle failure on nonzero return.
		WaveCloseReadFile( &hmmio, &pwfx );
		Error("LoadSound : WaveReadFile");
		return NULL;
    }
	
	//unlock the buffer
    lpDSB->Unlock( lpvAudio1, dwBytes1, NULL, 0 );
	
	//close the file
	WaveCloseReadFile( &hmmio, &pwfx );
	
	return lpDSB;
}


// Joue le son contenu dans un buffer DSound
BOOL DSPlay(LPDIRECTSOUNDBUFFER lpDSB )
{
	HRESULT	hr;

	if( lpDSB == NULL )
	{
		Error("DSPlay : lpDSB is NULL");
		return FALSE;
	}

	hr = lpDSB->SetCurrentPosition( 0 );
	if(!DSCheck(hr, "DSPlay : SetCurrentPosition"))
		return FALSE;

	hr = lpDSB->Play( 0, 0, 0 );
	if(!DSCheck(hr, "DSPlay : Play"))
		return FALSE;

	return TRUE;
}
