/* game.cpp */

#include <windows.h>
#include "dd.h"
#include "level.h"
#include "sizes.h"
#include "sound.h"
#include "key.h"
#include "state.h"
#include "GameOver.h"
#include "_error.h"
#include "HallOfFames.h"
#include "dm.h"
#include "di.h"


#define RAQUETTE_SPEED	16		// Vitesse de dplacement de la raquette


char briks[18][18];				// Les briques
int g_raquetteX = RAQUETTE_X;	// L'abscisse de la raquette
int g_ballX = BALL_X;			// |_ Les coordonnes de la balle
int g_ballY = BALL_Y;			// |
int g_level = 1;				// Le level
int g_score = 0;				// Le score
int g_lives = 4;				// Le nombre de vies restantes
BOOL g_bIsBallLunched = FALSE;	// Est-ce que la balle a t lance?
int g_speed = 2;				// La vitesse de jeu (1=slow, 2=medium, 3=fast)
int g_direction = 1;			/* La direction de la balle:
								 *    _      _
								 * 4 !\      /! 1
								 *      \  /
								 *
								 *      /  \
								 * 3 !_      _! 2
								 */
int g_NumBricksLeft;			// Le nombre de briques qui reste


/** Les rebonds **/

/* !  _      !
 * !  /!     !  /
 * !/        !/
 * !\     ou !\
 * !  \      !  _!
 * !         !
 */
void RebondG()
{
	PlayBounce();
	if( g_direction == 3 ) g_direction = 2;
	else if( g_direction == 4 ) g_direction = 1;
	else Error("RebondG : bad direction(%i)",g_direction);
}

/*      !       _  !
 *  \   !      !   !
 *    \ !        \ !
 *    / !  ou    / !
 * !_   !      /   !
 *      !          !
 */
void RebondD()
{
	PlayBounce();
	if( g_direction == 1 ) g_direction = 4;
	else if( g_direction == 2 ) g_direction = 3;
	else Error("RebondD : bad direction(%i)",g_direction);
}

/*
 * --------     ---------
 *   / \           / \
 * /     _!  ou !_     \
 *
 */
void RebondH()
{
	PlayBounce();
	if( g_direction == 1 ) g_direction = 2;
	else if( g_direction == 4 ) g_direction = 3;
	else Error("RebondH : bad direction(%i)",g_direction);
}

/*       _       _
 * \     /!     !\     /
 *   \ /     ou    \ /
 * --------     ---------
 */
void RebondB()
{
	PlayBounce();
	if( g_direction == 2 ) g_direction = 1;
	else if( g_direction == 3 ) g_direction = 4;
	else Error("RebondB : bad direction(%i)",g_direction);
}


// Lorque la balle est sortie de l'cran...
void BallLost()
{
	PlayBallLost();					//Joue le son
	g_lives--;						//Enlve une vie
	if( g_lives < 0 ) GameOver();	//Vrifie si game over
	g_bIsBallLunched = FALSE;		//Remet la balle sur la raquette
	g_raquetteX = RAQUETTE_X;		//et centre la raquette
	g_ballX = BALL_X;
	g_ballY = BALL_Y;
}


void CountNumBricksLeft()
{
	g_NumBricksLeft = 0;
	for( int i = 0 ; i < 18 ; i++ )
	{
		for( int j = 0 ; j < 18 ; j++ )
		{
			if((briks[i][j] > 0)&&(briks[i][j] < 5))
				g_NumBricksLeft++;
		}
	}
}


void NextLevel()
{
	PlayNextLevel();
	g_score += g_level * 1000;
	g_level++;
	if( g_level >  NUM_LEVELS )
	{
		InitHallOfFames( TRUE );
		return;
	}
	if( !LoadLevel( g_level ) )
		Error( "NextLevel : LoadLevel" );
	CountNumBricksLeft();
	g_byInput = 0;
	g_bStartKeyPressed = FALSE;
	g_bIsBallLunched = FALSE;
	g_ballX = BALL_X;
	g_ballY = BALL_Y;
	g_raquetteX = RAQUETTE_X;
	MusicPause( FALSE );
}


void BounceBriks(void)
{
	int i,j,u,d,l,r;

	for( i = 0 ; i < 18 ; i++ )
	{
		for( j = 0 ; j < 18 ; j++ )
		{
			if(!briks[i][j]) continue;	//Pas de brique

			//Regarde si collision
			if(   ( g_ballX + BALL_W >= BRIK_X + i * BRIK_W )
				&&( g_ballX <= BRIK_X + (i+1) * BRIK_W )
				&&( g_ballY + BALL_H >= BRIK_Y + j * BRIK_H )
				&&( g_ballY <= BRIK_Y + (j+1) * BRIK_H )
			)
			{
				//Si la brique n'est pas incassable ...
				if( briks[i][j] < 5 )
				{
					//Compte le score
					g_score += briks[i][j] * 100;
					//Casse la brique
					briks[i][j]--;
					//Une brique en moins?
					if(!briks[i][j])
					{
						g_NumBricksLeft--;
						if(!g_NumBricksLeft)
						{
							NextLevel();
							return;
						}
					}
				}

				u = (( j > 0 )&&( briks[i][j-1] )&&(g_ballY<=BRIK_Y+j*BRIK_H));
				d = (( j < 17 )&&( briks[i][j+1] )&&(g_ballY+BALL_H>=BRIK_Y+(j+1)*BRIK_H));
				l = (( i > 0 )&&( briks[i-1][j] )&&(g_ballX<=BRIK_X+i*BRIK_W));
				r = (( i < 17 )&&( briks[i+1][j] )&&(g_ballX+BALL_W>=BRIK_X+(i+1)*BRIK_W));

				//Rebond
				PlayBounce();
				switch( g_direction )
				{
				case 1:
					if((r)&&(!u))		//si il y a une brique  droite...
					{
						g_direction = 2;

						//Sort la balle de la brique
						g_ballY = BRIK_Y + (j+1) * BRIK_H;
					}
					else if((u)&&(!r))	//Si il y a une brique en haut...
					{
						g_direction = 4;

						//Sort la balle de la brique
						g_ballX = BRIK_X + i * BRIK_W - BALL_W;
					}
					else if     ( g_ballY > - g_ballX - BALL_W + BRIK_Y + (j+1) * BRIK_H + BRIK_X + i * BRIK_W )
					{
						g_direction = 2;

						//Sort la balle de la brique
						g_ballY = BRIK_Y + (j+1) * BRIK_H;
					}
					else if( g_ballY < - g_ballX - BALL_W + BRIK_Y + (j+1) * BRIK_H + BRIK_X + i * BRIK_W )
					{
						g_direction = 4;
						g_ballX = BRIK_X + i * BRIK_W - BALL_W;
					}
					else //Rebond sur le coin
					{
						Error("coin");
						g_direction = 3;
						g_ballY = BRIK_Y + (j+1) * BRIK_H;
						g_ballX = BRIK_X + i * BRIK_W - BALL_W;
					}
					break;
				case 2:
					if((r)&&(!d))
					{
						g_direction = 1;
						g_ballY = BRIK_Y + j * BRIK_H - BALL_H;
					}
					else if((d)&&(!r))
					{
						g_direction = 3;
						g_ballX = BRIK_X + i * BRIK_W - BALL_W;
					}
					else if     ( g_ballY + BALL_H > g_ballX + BALL_W + BRIK_Y + j * BRIK_H - BRIK_X - i * BRIK_W )
					{
						g_direction = 3;
						g_ballX = BRIK_X + i * BRIK_W - BALL_W;
					}
					else if( g_ballY + BALL_H < g_ballX + BALL_W + BRIK_Y + j * BRIK_H - BRIK_X - i * BRIK_W )
					{
						g_direction = 1;
						g_ballY = BRIK_Y + j * BRIK_H - BALL_H;
					}
					else
					{
						Error("coin");
						g_direction = 4;
						g_ballX = BRIK_X + i * BRIK_W - BALL_W;
						g_ballY = BRIK_Y + j * BRIK_H - BALL_H;
					}
					break;
				case 3:
					if((l)&&(!d))
					{
						g_direction = 4;
						g_ballY = BRIK_Y + (j-1) * BRIK_H;
					}
					else if((d)&&(!l)&&(!r))
					{
						g_direction = 2;
						g_ballX = BRIK_X + (i+1) * BRIK_W;
					}
					else if     ( g_ballY + BALL_H > - g_ballX + BRIK_Y + j * BRIK_H + BRIK_X + (i+1) * BRIK_W )
					{
						g_direction = 2;
						g_ballX = BRIK_X + (i+1) * BRIK_W;
					}
					else if( g_ballY + BALL_H < - g_ballX + BRIK_Y + j * BRIK_H + BRIK_X + (i+1) * BRIK_W )
					{
						g_direction = 4;
						g_ballY = BRIK_Y + (j-1) * BRIK_H;
					}
					else
					{
						Error("coin");
						g_direction = 1;
						g_ballX = BRIK_X + (i+1) * BRIK_W;
						g_ballY = BRIK_Y + (j-1) * BRIK_H;
					}
					break;
				case 4:
					if((l)&&(!u))
					{
						g_direction = 3;
						g_ballY = BRIK_Y + (j+1) * BRIK_H;
					}
					else if((u)&&(!l))
					{
						g_direction = 1;
						g_ballX = BRIK_X + (i+1) * BRIK_W;
					}
					else if     ( g_ballY < g_ballX + BRIK_Y + (j+1) * BRIK_H - BRIK_X - (i+1) * BRIK_W )
					{
						g_direction = 1;
						g_ballX = BRIK_X + (i+1) * BRIK_W;
					}
					else if( g_ballY > g_ballX + BRIK_Y + (j+1) * BRIK_H - BRIK_X - (i+1) * BRIK_W )
					{
						g_direction = 3;
						g_ballY = BRIK_Y + (j+1) * BRIK_H;
					}
					else
					{
						Error("coin");
						g_direction = 2;
						g_ballX = BRIK_X + (i+1) * BRIK_W;
						g_ballY = BRIK_Y + (j+1) * BRIK_H;
					}
				}
				
				return; //Un seul rebond  la fois
			}
		}
	}
}


// Fonction appel toutes les 20 ms grant le jeu
void GameLoop()
{
	/** Mouvements de la raquette **/
	
	// Gauche
	if( g_byInput & KEY_LEFT )
	{
		g_raquetteX -= RAQUETTE_SPEED;
		if( g_raquetteX < 0 )
			g_raquetteX = 0;
	}
	// Droite
	else if( g_byInput & KEY_RIGHT )
	{
		g_raquetteX += RAQUETTE_SPEED;
		if( g_raquetteX + RAQUETTE_W > RES_X )
			g_raquetteX = RES_X - RAQUETTE_W;
	}
	
	if( g_bIsBallLunched )
	{
		int speed;

		switch(g_speed)
		{
		case 1:
			speed = 3;
			break;
		case 2:
			speed = 5;
			break;
		case 3:
			speed = 7;
		}
		
		/** Mouvement de la balle **/
		switch( g_direction )
		{
		case 1:
			g_ballX += speed;
			g_ballY -= speed;
			break;
		case 2:
			g_ballX += speed;
			g_ballY += speed;
			break;
		case 3:
			g_ballX -= speed;
			g_ballY += speed;
			break;
		case 4:
			g_ballX -= speed;
			g_ballY -= speed;
			break;
		}
		
		/** Rebonds **/
		
		//Rebonds sur les bords de l'cran
		if( g_ballX - speed <= 0 )
			RebondG();
		if( g_ballX + BALL_W + speed >= RES_X )
			RebondD();
		if( g_ballY - speed <= DECOR_H )
			RebondH();
		
		//Rebonds sur la raquette
		if(   ( g_ballX + BALL_W >= g_raquetteX )
			&&( g_ballX <= g_raquetteX + RAQUETTE_W )
			&&( g_ballY + BALL_H >= RAQUETTE_Y )
			)
		{
			switch( g_direction )
			{
			case 2:
				if( g_ballY + BALL_H <= g_ballX + BALL_W + RAQUETTE_Y - g_raquetteX )
				{
					PlayBounce();
					g_direction = 1;
				}
				else
				{
					if( g_ballY + BALL_H > RAQUETTE_Y )
					{
						g_ballX = g_raquetteX - BALL_W;
					}
					else
					{
						PlayBounce();
						g_direction = 3;
						g_ballX = g_raquetteX - BALL_W;
					}
				}
				break;
			case 3:
				if( g_ballY + BALL_H <= - g_ballX + RAQUETTE_Y + g_raquetteX + RAQUETTE_W )
				{
					PlayBounce();
					g_direction = 4;
				}
				else
				{
					if( g_ballY + BALL_H > RAQUETTE_Y )
					{
						g_ballX = g_raquetteX + RAQUETTE_W;
					}
					else
					{
						PlayBounce();
						g_direction = 2;
						g_ballX = g_raquetteX + RAQUETTE_W;
					}
				}
			}
		}
		
		//Rebonds sur les briques
		/* 
		ID: algorithme optimis (voir avec un profiler si c'est utile)
		1.Slectionner les briques sur laquelle la balle est susceptible de rebondir
		2.Pour chacune de ces briques, vrifier les rebonds
		*/
		BounceBriks();
		
		/** Sortie de l'cran **/

		if( g_ballY > RAQUETTE_Y + RAQUETTE_H )
			BallLost();
	}
	else
	{
		/** Si la balle n'a pas t lance **/
		
		// Colle la balle  la raquette
		g_ballX = g_raquetteX + (RAQUETTE_W - BALL_W) / 2;
		g_ballX = g_raquetteX + (RAQUETTE_W - BALL_W) / 2;
		
		// Touche START
		if( g_bStartKeyPressed )
		{
			g_bStartKeyPressed = FALSE;

			//Touche START presse => Lancement de la balle
			g_bIsBallLunched = TRUE;
			g_direction = 1;
		}
	}
}


void SwitchToGameMode()
{
	MusicPause( FALSE );
	DIAcquire();
	g_state = STATE_GAME;
	g_bStartKeyPressed = FALSE;
	g_byInput = 0;
}


// Initialise le jeu
BOOL InitGameLevel1()
{
	g_level = 1;
	g_score = 0;
	g_lives = 4;
	g_raquetteX = RAQUETTE_X;
	g_ballX = BALL_X;
	g_ballY = BALL_Y;
	g_bIsBallLunched = FALSE;
	g_direction = 1;
	if( !LoadLevel(g_level) )
		return FALSE;
	CountNumBricksLeft();
//	SwitchToGameMode();
	return TRUE;
}
