/* letters.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <ddraw.h>
#include "sprites.h"
#include "ddutil.h"
#include "sizes.h"
#include "_error.h"


BOOL DDPrint( int x, int y, char *str )
{
	RECT rcDest;
	HRESULT hr;

	for( int i = 0 ; str[i] != 0 ; i++ )
	{
		if( str[i] == ' ' )
			continue;
		SetRect( &rcDest, x + i * LETTER_W, y, x + (i+1) * LETTER_W, y + LETTER_H );
		if(( '0' <= str[i] )&&( str[i] <= '9' ))
		{
			hr = g_lpDDSBack->Blt(
								&rcDest,
								g_lpDDSNumber[str[i]-'0'],
								NULL,
								DDBLT_WAIT,
								NULL );
			
			DDCheck(hr, "DDPrint : Blt g_lpDDSNumber[%i]",str[i]-'0');
		}
		else if( str[i] == '_' )
		{
			hr = g_lpDDSBack->Blt(
								&rcDest,
								g_lpDDSUnderscore,
								NULL,
								DDBLT_WAIT,
								NULL );
			
			DDCheck(hr, "DDPrint : Blt g_lpDDSUnderscore");
		}
		else
		{
			str[i] = toupper(str[i]);
			if(( str[i] < 'A' )||( str[i] > 'Z' ))
			{
				Error("DDPrint : bad character(%c)", str[i]);
				return FALSE;
			}
			hr = g_lpDDSBack->Blt(
								&rcDest,
								g_lpDDSLetter[str[i]-'A'],
								NULL,
								DDBLT_WAIT,
								NULL );
			
			DDCheck(hr, "DDPrint : Blt g_lpDDSLetter[%i]",str[i]-'A');
		}
	}
	return TRUE;
}