/* level.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <windows.h>
#include "game.h"
#include "resource.h"
#include "_error.h"
#include "main.h"
#include "dm.h"


// Charge un niveau
BOOL LoadLevel(int level)
{
	OutputDebugString("LoadLevel\n");
	int res;					// ID de la ressource
	HRSRC hResInfo = NULL;		// informations sur la ressource
	HGLOBAL hResData = NULL;	// handle des donnes de la ressource
	char *pData = NULL;			// donnes de la ressource
	
	// slectionne la ressource correspondante
	switch(level)
	{
	case 1:
		res = IDR_LEVEL1;
		break;
	case 2:
		res = IDR_LEVEL2;
		break;
	case 3:
		res = IDR_LEVEL3;
		break;
	case 4:
		res = IDR_LEVEL4;
		break;
	case 5:
		res = IDR_LEVEL5;
		break;
	case 6:
		res = IDR_LEVEL6;
		break;
	case 7:
		res = IDR_LEVEL7;
		break;
	case 8:
		res = IDR_LEVEL8;
		break;
	default:
		Error("LoadLevel : invalid level (%i)", level);
		return FALSE;
	}
	
	// Trouve la ressource
	hResInfo = FindResource( g_hInstance, MAKEINTRESOURCE(res), "LEVEL" );
	if( hResInfo == NULL )
	{
		Error("LoadLevel : FindResource (%i)", GetLastError() );
		return FALSE;
	}
	
	// Charge la ressource
	hResData = LoadResource( g_hInstance, hResInfo );
	if( hResData == NULL )
	{
		Error("LoadLevel : LoadResource (%i)", GetLastError() );
		return FALSE;
	}
	
	// Obtient un pointeur vers le donnes de la ressource
	pData = (char*)LockResource( hResData );
	if( pData == NULL )
	{
		Error("LoadLevel : LockResource" );
		return FALSE;
	}
	
	// Copie le niveau dans briks
	memcpy( briks, pData, 18 * 18 * sizeof(char) );
	
	//Charge la musique
	MusicLoad( level );

	return TRUE;
}
