/* load&save_game.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <windows.h>
#include "game.h"
#include "_error.h"
#include "dm.h"


//GameData: toutes les donnes dfinissant le jeu  un instant donn (utilis pour les sauvegardes)
struct GameData
{
	UINT uScore;
	BYTE byLevel;
	BYTE byLives;
	BYTE briks[18][18];
	UINT uBallX;
	UINT uBallY;
	BYTE byBallDirection;
	BOOL bIsBallLunched;
	UINT uRaquetteX;
	MUSIC_TIME mtCur;
} typedef GameData;


//Load : charge un jeu sauvegard (slot = numro de sauvegarde
void Load( int slot )
{
	GameData gamedata;
	HKEY  hKey;
	DWORD dwType = REG_BINARY;
	DWORD dwSize = sizeof(GameData);
	TCHAR valueName[7];
	
	//Charge la structure gamedata  partir de la BDR
	wsprintf( valueName, "Slot%.1d", slot );
	
	if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_CURRENT_USER, "Software\\AK\\Bricks\\Slots",
		                               NULL, KEY_READ, &hKey ) )
	{
		if( ERROR_SUCCESS == RegQueryValueEx( hKey, valueName,  0, &dwType, (BYTE*)&gamedata, &dwSize ) )
		{
			RegCloseKey( hKey );
			
			//copie le contenu de gamedata dans les variables de game.cpp
			g_score = gamedata.uScore;
			g_level = gamedata.byLevel;
			g_lives = gamedata.byLives;
			memcpy( briks, gamedata.briks, 18 * 18 * sizeof(char) );
			g_ballX = gamedata.uBallX;
			g_ballY = gamedata.uBallY;
			g_direction = gamedata.byBallDirection;
			g_bIsBallLunched = gamedata.bIsBallLunched;
			g_raquetteX = gamedata.uRaquetteX;
			g_mtCur = gamedata.mtCur;
			
			//Lance le jeu
			CountNumBricksLeft();
			SwitchToGameMode();
			return;
		}
	}
	Error("Ne peut charger Slot%.1d", slot );
}


//Save : sauvegarde une partie
void Save( int slot )
{
	GameData gamedata;
	HKEY  hKey; 
	DWORD dwDisposition;
	DWORD dwType = REG_BINARY;
	DWORD dwSize = sizeof(GameData);
	TCHAR valueName[7];
	
	//Rempli la structure gamedata
	gamedata.uScore = g_score;
	gamedata.byLevel = g_level;
	gamedata.byLives = g_lives;
	memcpy( gamedata.briks, briks, 18 * 18 * sizeof(char) );
	gamedata.uBallX = g_ballX;
	gamedata.uBallY = g_ballY;
	gamedata.byBallDirection = g_direction;
	gamedata.bIsBallLunched = g_bIsBallLunched;
	gamedata.uRaquetteX = g_raquetteX;
	gamedata.mtCur = g_mtCur;
	
	//Enregistre cette structure
	wsprintf( valueName, "Slot%.1d", slot );
	
	if( ERROR_SUCCESS == RegCreateKeyEx( HKEY_CURRENT_USER, "Software\\AK\\Bricks\\Slots", 0, "",
		                                 REG_OPTION_NON_VOLATILE, 
										 KEY_ALL_ACCESS, NULL, &hKey,
										 &dwDisposition ) )
	{
		if( ERROR_SUCCESS == RegSetValueEx( hKey, valueName,  0, dwType, (BYTE*)&gamedata, dwSize ) )
		{
			RegFlushKey( hKey );
			RegCloseKey( hKey );
			return;
		}
	}
	Error("Ne peut sauver Slot%.1d", slot );
}

