/* loadingwindow.c */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <windows.h>
#include "winutil.h"
#include "sizes.h"
#include "resource.h"


long FAR PASCAL LoadingWindowProc( HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam )
{
/*	switch(message)
	{
	case WM_PAINT:
		hDC = BeginPaint(hWnd,&ps);
		if(!TextOut(hDC,0,0,"Bricks!",7))
			OutputDebugString("Errpr\n");
		return 0;
	}*/
	return DefWindowProc(hWnd, message, wParam, lParam);
}


void ShowLoadingWindow(HINSTANCE h)
{
	WNDCLASS wc;
	HWND hWnd;
	HDC hDC;
	HBITMAP hBitmap;
	HDC hMemDC;

	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = LoadingWindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = h;
	wc.hIcon = LoadIcon( h, IDI_ASTERISK );
	wc.hCursor = LoadCursor( h, IDC_WAIT );
	wc.hbrBackground = (HBRUSH)COLOR_WINDOW;
	wc.lpszMenuName = NULL;
	wc.lpszClassName = "LoadingWindowClass";
	RegisterClass( &wc );
	
	// Create a window
	hWnd = CreateWindow(
				"LoadingWindowClass",
				"Loading...",
				WS_CAPTION,
				CW_USEDEFAULT,
				CW_USEDEFAULT,
				TITLE_W,
				TITLE_H,
				NULL,
				NULL,
				h,
				NULL );
	
	SizeAndCenterWindow( hWnd, TITLE_W, TITLE_H );	
	
	ShowWindow( hWnd, SW_SHOW );

	hDC = GetDC(hWnd);
	hMemDC = CreateCompatibleDC(hDC);
	if(hMemDC!=NULL)
	{
		hBitmap = LoadBitmap(h,MAKEINTRESOURCE(IDB_BRICKS));
		if(hBitmap!=NULL)
		{
			hBitmap = SelectObject(hMemDC,hBitmap);
			BitBlt(hDC,0,0,TITLE_W,TITLE_H,hMemDC,0,0,SRCCOPY);
			DeleteObject(SelectObject(hMemDC,hBitmap));
			DeleteDC(hMemDC);
		}
	}
	ReleaseDC(hWnd,hDC);
}


void CloseLoadingWindow(void)
{
	HWND hWnd = FindWindow(	"LoadingWindowClass", "Loading..." );
	DestroyWindow( hWnd );
	UnregisterClass( "LoadingWindowClass", GetModuleHandle(NULL) );
}