/* main.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <windows.h>

#ifndef SetWindowStyle	//Fonction non prsente dans windowsx.h
#define SetWindowStyle(hwnd,dw) SetWindowLong(hwnd,GWL_STYLE,dw)
#endif //SetWindowStyle

#include "dd.h"
#include "game.h"
#include "sprites.h"
#include "sound.h"
#include "_error.h"
#include "key.h"
#include "state.h"
#include "menu.h"
#include "HallOfFames.h"
#include "GameOver.h"
#include "config.h"
#include "dm.h"
#include "di.h"
#include "winutil.h"
#include "loadingwindow.h"


#define NAME	"BicksWndClass"	// Le nom de la classe
#define TITLE	"Bricks!"		// Le titre de la fenetre
#define TIME	20				// L'intervalle de temps (pour le mouvement)


HMODULE g_hInstance = NULL;		// handle du programme
HWND g_hWnd = NULL;				// handle de la fenetre
RECT g_rcWindow;				// rectangle de la fenetre
BOOL g_bActive = FALSE;			// est-ce que le jeu est actif?
BOOL g_bPause = FALSE;			// est-ce que le jeu est en pause ?


//Change Full Screen/Windowed mode
BOOL SwitchDisplayMode()
{
	UnloadSprites();					//Dcharge les sprites
	DDClose();							//Ferme DDraw
	g_bFullScreen = !g_bFullScreen;		//Change la varible
	SaveConfig();						//Sauve la config
	//Reconfigure la fenetre
	if( g_bFullScreen )
	{
		SetWindowStyle( g_hWnd, WS_POPUP );		//Enleve la barre de titre
		SetWindowText( g_hWnd, "" );			//Et le titre
		ShowWindow( g_hWnd, SW_SHOWMAXIMIZED );	//Maximize la fenetre
	}
	else
	{
		SetWindowStyle( g_hWnd, WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX );	//Met une barre de titre
		SetWindowText( g_hWnd, TITLE );										//Met un titre
		ShowWindow( g_hWnd, SW_RESTORE );									//Dmaximize la fenetre
		SizeAndCenterWindow( g_hWnd, RES_X, RES_Y );						//Change la taille de la fenetre et centre celle-ci
	}
	return 
		DDInit() &&						//reInitialise DDraw
		LoadSprites();					//reCharge les sprites
}


// Gestion des messages de Windows
long FAR PASCAL WindowProc( HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam )
{
	switch( message )
	{
	// Activation/Dsactivation de la fenetre
	case WM_ACTIVATEAPP:
		if( g_bPause )
			break;
		g_bActive = (BOOL) wParam;
		if( !g_bActive )
		{
			InvalidateRect( hWnd, NULL, TRUE );
			if(g_state == STATE_GAME)
			{
				MusicPause( TRUE );
				DIUnacquire();
			}
		}
		else
		{
			if(g_state == STATE_GAME)
			{
				MusicPause( FALSE );
				DIAcquire();
			}
		}
		return 0;
	// Agrandissement/Rduction de la fenetre
	case WM_SIZE:
		if( g_bPause )
			break;
		// Our window size is fixed, so this could
		// only be a minimize or maximize
		if ( wParam == SIZE_MINIMIZED )
		{
			g_bActive = FALSE;
		}
		else
		{
			g_bActive = TRUE;
		}
		return 0;
	// Dplacement de la fenetre
	case WM_MOVE:
		// get the client rectangle
		if ( g_bFullScreen )
		{
			//SetRect( &g_rcWindow, 0, 0, GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ) );
			SetRect( &g_rcWindow, 0, 0, RES_X, RES_Y );
		}
		else
		{
			GetClientRect( hWnd, &g_rcWindow );
			ClientToScreen( hWnd, (LPPOINT)&g_rcWindow );
			ClientToScreen( hWnd, (LPPOINT)&g_rcWindow+1 );
		}
		break;
	
	// For the sake of simplicity, we're not using DirectInput but are
	// reading the keyboard through the message queue. You will see the
	// detrimental effect this has on the frame rate. DirectInput will
	// be used later.

	// Touche presse
	case WM_KEYDOWN:
		switch( wParam )
		{
/*		case VK_LEFT:
		case VK_NUMPAD4:
			g_byInput |= KEY_LEFT;
			break;
		case VK_RIGHT:
		case VK_NUMPAD6:
			g_byInput |= KEY_RIGHT;
			break;*/
		case VK_ESCAPE:
			if( g_state == STATE_GAME )
			{
				InitMenu();
			}
			else if( g_state == STATE_MENU )
			{
				SwitchToGameMode();
			}
			return 0;
		// Dpart ou enlever le GameOver
		case VK_RETURN:
		case VK_SPACE:
			if( g_bActive )
				g_bStartKeyPressed = TRUE;
			break;
		// Pause
		case 'p':
		case 'P':
			if( g_state == STATE_GAME)
			{
				g_bPause = !g_bPause;
				if( g_bPause)
				{
					DIUnacquire();
					MusicPause( TRUE );
				}
				else
				{
					DIAcquire();
					MusicPause( FALSE );
				}
				g_bActive = !g_bPause;
				if( !g_bActive )
					InvalidateRect( hWnd, NULL, TRUE );
			}
		}
		break;
	
	// Touche relache
	case WM_KEYUP:
		switch( g_state )
		{
/*		case STATE_GAME:
			switch( wParam )
			{
			case VK_LEFT:
			case VK_NUMPAD4:
				g_byInput &= ~KEY_LEFT;
				break;
			case VK_RIGHT:
			case VK_NUMPAD6:
				g_byInput &= ~KEY_RIGHT;
				break;
			}
			break;*/
		case STATE_MENU:
			MenuPressKey( ConvertKey( wParam ) );
			break;
		case STATE_HALLOFFAMES:
			HallOfFamesPressKey( ConvertKey( wParam ) );
			break;
		case STATE_GAMEOVER:
			GameOverPressKey( ConvertKey( wParam ) );
			break;
		}
		break;
	
	// Utilitse seulement pendant la pause
	case WM_PAINT:
		if( !g_bActive )
		{
			DDPaintPause();
		}
		break;
	
	case WM_SYSKEYUP:
		switch( wParam )
		{
		// handle ALT+ENTER ( fullscreen/windowed switch )
		case VK_RETURN:
			SwitchDisplayMode();
			break;
		}
		break;
	
	// Enlve le curseur
	case WM_SETCURSOR:
		SetCursor( NULL );
		break;
	
	// Destruction de la fenetre => fin du programme
	case WM_DESTROY:
		PostQuitMessage( 0 );
		return 0;
	}
	
	return DefWindowProc(hWnd, message, wParam, lParam);
}


int WINAPI WinMain(HINSTANCE h,
				   HINSTANCE p,
				   LPSTR cmdlgn,
				   int show)
{
	WNDCLASS	wc;		//The window class

	g_hInstance = h;

	ShowLoadingWindow(h);
	
	// Charge les options de configuration
	LoadConfig();
	
	/** Cre une fenetre **/
	
	// Set up and register window class
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = h;
	wc.hIcon = LoadIcon( h, IDI_APPLICATION );
	wc.hCursor = LoadCursor( h, IDC_ARROW );
	wc.hbrBackground = NULL;
	wc.lpszMenuName = NULL;
	wc.lpszClassName = NAME;
	RegisterClass( &wc );
	
	// Create a window
	if( g_bFullScreen )
		g_hWnd = CreateWindow(
				NAME,
				"",
				WS_POPUP,
				CW_USEDEFAULT,
				CW_USEDEFAULT,
				640,
				480,
				NULL,
				NULL,
				h,
				NULL );
	else
		g_hWnd = CreateWindow(
				NAME,
				TITLE,
				WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX,
				CW_USEDEFAULT,
				CW_USEDEFAULT,
				640,
				480,
				NULL,
				NULL,
				h,
				NULL );
	
	//Do we have a window?  if not exit
	if( !g_hWnd )
		return -1;
	
	/** Initialisations **/
		
	if(!DSInit())					//DirectSound
	{
		MessageBox( g_hWnd, "Can't initialize DirectSound", "ERROR", MB_OK | MB_ICONSTOP );
		return -2;
	}
	
	if(!DMInit( g_lpDS, g_hWnd ))	//DirectMusic
	{
		DSClose();
		MessageBox( g_hWnd, "Can't initialize DirectMusic", "ERROR", MB_OK | MB_ICONSTOP );
		return -3;
	}
	
	if(!LoadSounds())				//Charge les sons
	{
		DMClose();
		DSClose();
		MessageBox( g_hWnd, "Can't load sounds", "ERROR", MB_OK | MB_ICONSTOP );
		return -4;
	}
		
	InitMenu();
	SetMusic( g_bMusic );
	
	SizeAndCenterWindow( g_hWnd, RES_X, RES_Y );	
	
	if( g_bFullScreen )
		ShowWindow( g_hWnd, SW_SHOWMAXIMIZED );
	else
		ShowWindow( g_hWnd, SW_SHOW );

	if(!DDInit())					//DirectDraw
	{
		DMClose();
		DSClose();
		MessageBox( g_hWnd, "Can't initialize DirectDraw", "ERROR", MB_OK | MB_ICONSTOP );
		return -5;
	}

	if(!LoadSprites())	//Charge les bmp
	{
		DDClose();
		DMClose();
		DSClose();
		MessageBox( g_hWnd, "Can't load graphics", "ERROR", MB_OK | MB_ICONSTOP );
		return -6;
	}

	if(!DIInit( h, g_hWnd, g_bMouse ))	//DirectInput
	{
		UnloadSprites();
		DDClose();
		DMClose();
		DSClose();
		MessageBox( g_hWnd, "Can't initialize DirectInput", "ERROR", MB_OK | MB_ICONSTOP );
		return -7;
	}

	if(!InitGameLevel1())	//Initialise le jeu
	{
		UnloadSprites();
		DDClose();
		DMClose();
		DSClose();
		DIClose();
		MessageBox( g_hWnd, "Can't initialize game", "ERROR", MB_OK | MB_ICONSTOP );
		return -8;
	}

	MSG msg;
	DWORD dwStartFrame = 0;
	
	CloseLoadingWindow();
	OutputDebugString("here\n");
	
	//Infinite look for message loop
	/*
	 * La boucle des messages de Windows: pour une meilleur gestion du jeu, l'cran
	 * n'est pas rafraichit  intervalles rguliers, mais ds que le programme n'a
	 * rien d'autre  faire (c'est--dire trs souvent) par un appel  DDUpdate()
	 * Quand au jeu, la fonction GameLoop() est appelle  intervalles rguliers
	 * afin d'obtenir des dplacements  vitesse rgulire
	 */
	while( 1 )
	{
		// Regarde si un message est en attente
    	if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
    	{
			// Gre le message Windows
        	if( !GetMessage( &msg, NULL, 0, 0 ) )
        	{
				// Fin du programme demande (par PostQuitMessage) => sortie de la boucle
				break;
        	}
        	TranslateMessage(&msg);
        	DispatchMessage(&msg);
    	}
		else	// Lorsque qu'aucun message n'est  traiter
		{
			// Si la fenetre est active, on rafrachit l'cran
			if( g_bActive )
				DDUpdate();
			if( !g_bMouse )
				ProcessKBInput();
		}
		// Appelle la fonction GameLoop() toutes les TIME millisecondes
		if( g_bActive )
		{
			if( GetTickCount() - dwStartFrame > TIME )
			{
				dwStartFrame = GetTickCount();
				if( g_state == STATE_GAME )
					GameLoop();
			}
		}
	}
	
	UnloadSprites();
	DDClose();						// Ferme DD
	DMClose();						// Ferme DM
	DSClose();						// Ferme DS
	DIClose();						// Ferme DI
	UnregisterClass( NAME, h );		// Dsenregistre la classe de la fenetre
	
	OutputDebugString("Program correctly terminated\n");

	return 0;
}

