/* menu.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 *
 * New Game --------> Start a new game
 *
 * Load Game -------> Open load game menu (save slots)
 *
 * Save Game -------> Open save game menu (save slots)
 *
 * Options
 *     |
 *     |- FullScreen(Yes/No)
 *     |
 *     |- Sounds(Yes/No)
 *     |
 *     |- Music(Yes/No)
 *     |
 *     |- Game speed(Slow/Medium/Fast)
 *     |
 *     |- Control(Mouse/Keyboard)
 *
 *
 * Hall of Fames ---> Open hall of Fames window (hall of fames list)
 *
 * Exit ------------> Close the program
 *
 */

#include <ddraw.h>
#include "dd.h"
#include "sprites.h"
#include "main.h"
#include "HallOfFames.h"
#include "key.h"
#include "state.h"
#include "game.h"
#include "letters.h"
#include "sizes.h"
#include "ddutil.h"
#include "sound.h"
#include "config.h"
#include "load&save_game.h"
#include "dm.h"
#include "di.h"


//Les lments des menus
#define MENUITEM_NEWGAME			0
#define MENUITEM_LOADGAME			1
#define MENUITEM_SAVEGAME			2
#define MENUITEM_OPTIONS			3
#define MENUITEM_HALLOFFAMES		4
#define MENUITEM_EXIT				5
#define MENUITEM_OPTIONS_FULLSCREEN	6
#define MENUITEM_OPTIONS_SOUNDS		7
#define MENUITEM_OPTIONS_MUSIC		8
#define MENUITEM_OPTIONS_SPEED		9
#define MENUITEM_OPTIONS_CONTROL	10

#define MENUITEM_SLOT1				11
#define MENUITEM_SLOT2				12
#define MENUITEM_SLOT3				13
#define MENUITEM_SLOT4				14
#define MENUITEM_SLOT5				15
#define MENUITEM_SLOT6				16
#define MENUITEM_SLOT7				17
#define MENUITEM_SLOT8				18

#define MENUITEM_QUIT				20

//Les diffrents menus
#define MENU_MAIN					30	//Menu principal
#define MENU_LOADGAME				31	//Menu Load Game
#define MENU_SAVEGAME				32	//Menu Save Game
#define MENU_OPTIONS				33	//Menu Options


int g_SelectedItem = MENUITEM_NEWGAME;	//L'lment de menu slectionn
int g_Menu = MENU_MAIN;					//Le menu dans lequel on se trouve


void ExitProgram()
{
	PostMessage( g_hWnd, WM_CLOSE, 0, 0 );
}


//InitMenu: initialise le menu
void InitMenu()
{
	DIUnacquire();
	MusicPause( TRUE );
	g_state = STATE_MENU;
	LoadConfig();
	g_SelectedItem = MENUITEM_NEWGAME;
	g_Menu = MENU_MAIN;
}


//MenuPressKey: fonction appele  chaque fois qu'une touche du clavier est presse quand le
//programme est en mode menu (STATE_MENU)
void MenuPressKey( int key )
{
	switch( g_Menu )
	{
	case MENU_MAIN:
		switch( key )
		{
		case KEY_UP:
			switch( g_SelectedItem )
			{
			case MENUITEM_NEWGAME:
				g_SelectedItem = MENUITEM_EXIT;
				break;
			case MENUITEM_LOADGAME:
				g_SelectedItem = MENUITEM_NEWGAME;
				break;
			case MENUITEM_SAVEGAME:
				g_SelectedItem = MENUITEM_LOADGAME;
				break;
			case MENUITEM_OPTIONS:
				g_SelectedItem = MENUITEM_SAVEGAME;
				break;
			case MENUITEM_HALLOFFAMES:
				g_SelectedItem = MENUITEM_OPTIONS;
				break;
			case MENUITEM_EXIT:
				g_SelectedItem = MENUITEM_HALLOFFAMES;
				break;
			}
			break;
		case KEY_DOWN:
			switch( g_SelectedItem )
			{
			case MENUITEM_NEWGAME:
				g_SelectedItem = MENUITEM_LOADGAME;
				break;
			case MENUITEM_LOADGAME:
				g_SelectedItem = MENUITEM_SAVEGAME;
				break;
			case MENUITEM_SAVEGAME:
				g_SelectedItem = MENUITEM_OPTIONS;
				break;
			case MENUITEM_OPTIONS:
				g_SelectedItem = MENUITEM_HALLOFFAMES;
				break;
			case MENUITEM_HALLOFFAMES:
				g_SelectedItem = MENUITEM_EXIT;
				break;
			case MENUITEM_EXIT:
				g_SelectedItem = MENUITEM_NEWGAME;
				break;
			}
			break;
		case KEY_RETURN:
			switch( g_SelectedItem )
			{
			case MENUITEM_NEWGAME:
				InitGameLevel1();
				SwitchToGameMode();
				break;
			case MENUITEM_LOADGAME:
				g_Menu = MENU_LOADGAME;
				g_SelectedItem = MENUITEM_QUIT;
				break;
			case MENUITEM_SAVEGAME:
				g_Menu = MENU_SAVEGAME;
				g_SelectedItem = MENUITEM_QUIT;
				break;
			case MENUITEM_OPTIONS:
				g_Menu = MENU_OPTIONS;
				g_SelectedItem = MENUITEM_OPTIONS_FULLSCREEN;
				break;
			case MENUITEM_HALLOFFAMES:
				InitHallOfFames( FALSE );
				break;
			case MENUITEM_EXIT:
				ExitProgram();
				break;
			}
			break;
		}
		break;
	case MENU_LOADGAME:
		switch( key )
		{
		case KEY_UP:
			switch( g_SelectedItem )
			{
			case MENUITEM_SLOT1:
				g_SelectedItem = MENUITEM_QUIT;
				break;
			case MENUITEM_SLOT2:
				g_SelectedItem = MENUITEM_SLOT1;
				break;
			case MENUITEM_SLOT3:
				g_SelectedItem = MENUITEM_SLOT2;
				break;
			case MENUITEM_SLOT4:
				g_SelectedItem = MENUITEM_SLOT3;
				break;
			case MENUITEM_SLOT5:
				g_SelectedItem = MENUITEM_SLOT4;
				break;
			case MENUITEM_SLOT6:
				g_SelectedItem = MENUITEM_SLOT5;
				break;
			case MENUITEM_SLOT7:
				g_SelectedItem = MENUITEM_SLOT6;
				break;
			case MENUITEM_SLOT8:
				g_SelectedItem = MENUITEM_SLOT7;
				break;
			case MENUITEM_QUIT:
				g_SelectedItem = MENUITEM_SLOT8;
				break;
			}
			break;
		case KEY_DOWN:
			switch( g_SelectedItem )
			{
			case MENUITEM_SLOT1:
				g_SelectedItem = MENUITEM_SLOT2;
				break;
			case MENUITEM_SLOT2:
				g_SelectedItem = MENUITEM_SLOT3;
				break;
			case MENUITEM_SLOT3:
				g_SelectedItem = MENUITEM_SLOT4;
				break;
			case MENUITEM_SLOT4:
				g_SelectedItem = MENUITEM_SLOT5;
				break;
			case MENUITEM_SLOT5:
				g_SelectedItem = MENUITEM_SLOT6;
				break;
			case MENUITEM_SLOT6:
				g_SelectedItem = MENUITEM_SLOT7;
				break;
			case MENUITEM_SLOT7:
				g_SelectedItem = MENUITEM_SLOT8;
				break;
			case MENUITEM_SLOT8:
				g_SelectedItem = MENUITEM_QUIT;
				break;
			case MENUITEM_QUIT:
				g_SelectedItem = MENUITEM_SLOT1;
				break;
			}
			break;
		case KEY_RETURN:
			switch( g_SelectedItem )
			{
			case MENUITEM_SLOT1:
				Load( 1 );
				break;
			case MENUITEM_SLOT2:
				Load( 2 );
				break;
			case MENUITEM_SLOT3:
				Load( 3 );
				break;
			case MENUITEM_SLOT4:
				Load( 4 );
				break;
			case MENUITEM_SLOT5:
				Load( 5 );
				break;
			case MENUITEM_SLOT6:
				Load( 6 );
				break;
			case MENUITEM_SLOT7:
				Load( 7 );
				break;
			case MENUITEM_SLOT8:
				Load( 8 );
				break;
			case MENUITEM_QUIT:
				g_Menu = MENU_MAIN;
				g_SelectedItem = MENUITEM_LOADGAME;
				break;
			}
			break;
		}
		break;
	case MENU_SAVEGAME:
		switch( key )
		{
		case KEY_UP:
			switch( g_SelectedItem )
			{
			case MENUITEM_SLOT1:
				g_SelectedItem = MENUITEM_QUIT;
				break;
			case MENUITEM_SLOT2:
				g_SelectedItem = MENUITEM_SLOT1;
				break;
			case MENUITEM_SLOT3:
				g_SelectedItem = MENUITEM_SLOT2;
				break;
			case MENUITEM_SLOT4:
				g_SelectedItem = MENUITEM_SLOT3;
				break;
			case MENUITEM_SLOT5:
				g_SelectedItem = MENUITEM_SLOT4;
				break;
			case MENUITEM_SLOT6:
				g_SelectedItem = MENUITEM_SLOT5;
				break;
			case MENUITEM_SLOT7:
				g_SelectedItem = MENUITEM_SLOT6;
				break;
			case MENUITEM_SLOT8:
				g_SelectedItem = MENUITEM_SLOT7;
				break;
			case MENUITEM_QUIT:
				g_SelectedItem = MENUITEM_SLOT8;
				break;
			}
			break;
		case KEY_DOWN:
			switch( g_SelectedItem )
			{
			case MENUITEM_SLOT1:
				g_SelectedItem = MENUITEM_SLOT2;
				break;
			case MENUITEM_SLOT2:
				g_SelectedItem = MENUITEM_SLOT3;
				break;
			case MENUITEM_SLOT3:
				g_SelectedItem = MENUITEM_SLOT4;
				break;
			case MENUITEM_SLOT4:
				g_SelectedItem = MENUITEM_SLOT5;
				break;
			case MENUITEM_SLOT5:
				g_SelectedItem = MENUITEM_SLOT6;
				break;
			case MENUITEM_SLOT6:
				g_SelectedItem = MENUITEM_SLOT7;
				break;
			case MENUITEM_SLOT7:
				g_SelectedItem = MENUITEM_SLOT8;
				break;
			case MENUITEM_SLOT8:
				g_SelectedItem = MENUITEM_QUIT;
				break;
			case MENUITEM_QUIT:
				g_SelectedItem = MENUITEM_SLOT1;
				break;
			}
			break;
		case KEY_RETURN:
			switch( g_SelectedItem )
			{
			case MENUITEM_SLOT1:
				Save( 1 );
				break;
			case MENUITEM_SLOT2:
				Save( 2 );
				break;
			case MENUITEM_SLOT3:
				Save( 3 );
				break;
			case MENUITEM_SLOT4:
				Save( 4 );
				break;
			case MENUITEM_SLOT5:
				Save( 5 );
				break;
			case MENUITEM_SLOT6:
				Save( 6 );
				break;
			case MENUITEM_SLOT7:
				Save( 7 );
				break;
			case MENUITEM_SLOT8:
				Save( 8 );
				break;
			case MENUITEM_QUIT:
				g_Menu = MENU_MAIN;
				g_SelectedItem = MENUITEM_SAVEGAME;
				break;
			}
			break;
		}
		break;
	case MENU_OPTIONS:
		switch( key )
		{
		case KEY_UP:
			switch( g_SelectedItem )
			{
			case MENUITEM_OPTIONS_FULLSCREEN:
				g_SelectedItem = MENUITEM_QUIT;
				break;
			case MENUITEM_OPTIONS_SOUNDS:
				g_SelectedItem = MENUITEM_OPTIONS_FULLSCREEN;
				break;
			case MENUITEM_OPTIONS_MUSIC:
				g_SelectedItem = MENUITEM_OPTIONS_SOUNDS;
				break;
			case MENUITEM_OPTIONS_SPEED:
				g_SelectedItem = MENUITEM_OPTIONS_MUSIC;
				break;
			case MENUITEM_OPTIONS_CONTROL:
				g_SelectedItem = MENUITEM_OPTIONS_SPEED;
				break;
			case MENUITEM_QUIT:
				g_SelectedItem = MENUITEM_OPTIONS_CONTROL;
				break;
			}
			break;
		case KEY_DOWN:
			switch( g_SelectedItem )
			{
			case MENUITEM_OPTIONS_FULLSCREEN:
				g_SelectedItem = MENUITEM_OPTIONS_SOUNDS;
				break;
			case MENUITEM_OPTIONS_SOUNDS:
				g_SelectedItem = MENUITEM_OPTIONS_MUSIC;
				break;
			case MENUITEM_OPTIONS_MUSIC:
				g_SelectedItem = MENUITEM_OPTIONS_SPEED;
				break;
			case MENUITEM_OPTIONS_SPEED:
				g_SelectedItem = MENUITEM_OPTIONS_CONTROL;
				break;
			case MENUITEM_OPTIONS_CONTROL:
				g_SelectedItem = MENUITEM_QUIT;
				break;
			case MENUITEM_QUIT:
				g_SelectedItem = MENUITEM_OPTIONS_FULLSCREEN;
				break;
			}
			break;
		case KEY_RETURN:
			switch( g_SelectedItem )
			{
			case MENUITEM_OPTIONS_FULLSCREEN:
				SwitchDisplayMode();
				break;
			case MENUITEM_OPTIONS_SOUNDS:
				g_bSounds = !g_bSounds;
				break;
			case MENUITEM_OPTIONS_MUSIC:
				g_bMusic = !g_bMusic;
				SetMusic( g_bMusic );
				break;
			case MENUITEM_OPTIONS_SPEED:
				switch( g_speed )
				{
				case 1:
					g_speed = 2;
					break;
				case 2:
					g_speed = 3;
					break;
				case 3:
					g_speed = 1;
					break;
				}
				break;
			case MENUITEM_OPTIONS_CONTROL:
				DISwitchControlMode();
				break;
			case MENUITEM_QUIT:
				g_Menu = MENU_MAIN;
				g_SelectedItem = MENUITEM_OPTIONS;
				break;
			}
			SaveConfig();
			break;
		}
		break;
	}
}


//DrawCursor: dessine le curseur du menu aux coordonnes (x,y)
void DrawCursor( int x, int y )
{
	HRESULT hr;
	RECT rcDest;
	
	SetRect( &rcDest, x, y, x + CURSOR_W, y + CURSOR_H );
	
	hr = g_lpDDSBack->Blt(
						&rcDest,
						g_lpDDSCursor,
						NULL,
						DDBLT_WAIT,
						NULL );
	
	DDCheck(hr, "DrawCursor : Blt g_lpDDSCursor");
}


//DrawMenu: dessine le menu
void DrawMenu()
{
	int y;
	switch( g_Menu )
	{
	case MENU_MAIN:
		DDPrint( NEWGAME_X, NEWGAME_Y, "New Game" );
		DDPrint( LOADGAME_X, LOADGAME_Y, "Load Game" );
		DDPrint( SAVEGAME_X, SAVEGAME_Y, "Save Game" );
		DDPrint( OPTIONS_X, OPTIONS_Y, "Options" );
		DDPrint( HALLOFFAMES_X, HALLOFFAMES_Y, "Hall of Fames" );
		DDPrint( EXIT_X, EXIT_Y, "Exit" );
		switch( g_SelectedItem )
		{
		case MENUITEM_NEWGAME:
			y = NEWGAME_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_LOADGAME:
			y = LOADGAME_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SAVEGAME:
			y = SAVEGAME_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_OPTIONS:
			y = OPTIONS_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_HALLOFFAMES:
			y = HALLOFFAMES_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_EXIT:
			y = EXIT_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		}
		DrawCursor( NEWGAME_X - CURSOR_W, y );
		break;
	case MENU_LOADGAME:
		DDPrint( SLOT1_X, SLOT1_Y, "Slot1" );
		DDPrint( SLOT2_X, SLOT2_Y, "Slot2" );
		DDPrint( SLOT3_X, SLOT3_Y, "Slot3" );
		DDPrint( SLOT4_X, SLOT4_Y, "Slot4" );
		DDPrint( SLOT5_X, SLOT5_Y, "Slot5" );
		DDPrint( SLOT6_X, SLOT6_Y, "Slot6" );
		DDPrint( SLOT7_X, SLOT7_Y, "Slot7" );
		DDPrint( SLOT8_X, SLOT8_Y, "Slot8" );
		DDPrint( LOADGAME_QUIT_X, LOADGAME_QUIT_Y, "Back to main menu");
		switch( g_SelectedItem )
		{
		case MENUITEM_SLOT1:
			y = SLOT1_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT2:
			y = SLOT2_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT3:
			y = SLOT3_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT4:
			y = SLOT4_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT5:
			y = SLOT5_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT6:
			y = SLOT6_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT7:
			y = SLOT7_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT8:
			y = SLOT8_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_QUIT:
			y = LOADGAME_QUIT_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		}
		DrawCursor( LOADGAME_QUIT_X - LETTER_W, y );
		break;
	case MENU_SAVEGAME:
		DDPrint( SLOT1_X, SLOT1_Y, "Slot1" );
		DDPrint( SLOT2_X, SLOT2_Y, "Slot2" );
		DDPrint( SLOT3_X, SLOT3_Y, "Slot3" );
		DDPrint( SLOT4_X, SLOT4_Y, "Slot4" );
		DDPrint( SLOT5_X, SLOT5_Y, "Slot5" );
		DDPrint( SLOT6_X, SLOT6_Y, "Slot6" );
		DDPrint( SLOT7_X, SLOT7_Y, "Slot7" );
		DDPrint( SLOT8_X, SLOT8_Y, "Slot8" );
		DDPrint( SAVEGAME_QUIT_X, SAVEGAME_QUIT_Y, "Back to main menu");
		switch( g_SelectedItem )
		{
		case MENUITEM_SLOT1:
			y = SLOT1_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT2:
			y = SLOT2_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT3:
			y = SLOT3_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT4:
			y = SLOT4_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT5:
			y = SLOT5_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT6:
			y = SLOT6_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT7:
			y = SLOT7_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_SLOT8:
			y = SLOT8_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_QUIT:
			y = SAVEGAME_QUIT_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		}
		DrawCursor( SAVEGAME_QUIT_X - LETTER_W, y );
		break;
	case MENU_OPTIONS:
		DDPrint( OPTIONS_FULLSCREEN_X, OPTIONS_FULLSCREEN_Y, "Full Screen" );
		DDPrint( OPTIONS_SOUNDS_X, OPTIONS_SOUNDS_Y, "Sounds" );
		DDPrint( OPTIONS_MUSIC_X, OPTIONS_MUSIC_Y, "Music" );
		DDPrint( OPTIONS_SPEED_X, OPTIONS_SPEED_Y, "Speed" );
		DDPrint( OPTIONS_CONTROL_X, OPTIONS_CONTROL_Y, "Control" );
		DDPrint( OPTIONS_QUIT_X, OPTIONS_QUIT_Y, "Back to main menu" );
		switch( g_SelectedItem )
		{
		case MENUITEM_OPTIONS_FULLSCREEN:
			y = OPTIONS_FULLSCREEN_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_OPTIONS_SOUNDS:
			y = OPTIONS_SOUNDS_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_OPTIONS_MUSIC:
			y = OPTIONS_MUSIC_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_OPTIONS_SPEED:
			y = OPTIONS_SPEED_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_OPTIONS_CONTROL:
			y = OPTIONS_CONTROL_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		case MENUITEM_QUIT:
			y = OPTIONS_QUIT_Y + ( LETTER_H - CURSOR_H ) / 2;
			break;
		}
		DrawCursor( OPTIONS_FULLSCREEN_X - CURSOR_W, y );
		switch( g_bFullScreen )
		{
		case TRUE:
			DDPrint( OPTIONS_FULLSCREEN_X + (strlen("Full Screen")+2) * LETTER_W, OPTIONS_FULLSCREEN_Y, "Yes" );
			break;
		case FALSE:
			DDPrint( OPTIONS_FULLSCREEN_X + (strlen("Full Screen")+2) * LETTER_W, OPTIONS_FULLSCREEN_Y, "No" );
			break;
		}
		switch( g_bSounds )
		{
		case TRUE:
			DDPrint( OPTIONS_SOUNDS_X + (strlen("Sounds")+2) * LETTER_W, OPTIONS_SOUNDS_Y, "Yes" );
			break;
		case FALSE:
			DDPrint( OPTIONS_SOUNDS_X + (strlen("Sounds")+2) * LETTER_W, OPTIONS_SOUNDS_Y, "No" );
			break;
		}
		switch( g_bMusic )
		{
		case TRUE:
			DDPrint( OPTIONS_MUSIC_X + (strlen("Music")+2) * LETTER_W, OPTIONS_MUSIC_Y, "Yes" );
			break;
		case FALSE:
			DDPrint( OPTIONS_MUSIC_X + (strlen("Music")+2) * LETTER_W, OPTIONS_MUSIC_Y, "No" );
			break;
		}
		switch( g_speed )
		{
		case 1:
			DDPrint( OPTIONS_SPEED_X + (strlen("Speed")+2) * LETTER_W, OPTIONS_SPEED_Y, "Slow" );
			break;
		case 2:
			DDPrint( OPTIONS_SPEED_X + (strlen("Speed")+2) * LETTER_W, OPTIONS_SPEED_Y, "Medium" );
			break;
		case 3:
			DDPrint( OPTIONS_SPEED_X + (strlen("Speed")+2) * LETTER_W, OPTIONS_SPEED_Y, "Fast" );
			break;
		}
		switch( g_bMouse )
		{
		case TRUE:
			DDPrint( OPTIONS_CONTROL_X + (strlen("Control")+2) * LETTER_W, OPTIONS_CONTROL_Y, "Mouse" );
			break;
		case FALSE:
			DDPrint( OPTIONS_CONTROL_X + (strlen("Control")+2) * LETTER_W, OPTIONS_CONTROL_Y, "Kb" );
			break;
		}
		break;
	}
}
