/* sizes.h : sizes and positions */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef __SIZES_H
#define __SIZES_H


#include "dd.h"												// Pour RES_X et RES_Y


#define RAQUETTE_W				128							// largeur de la raquette
#define RAQUETTE_H				32							// hauteur de la raquette
#define RAQUETTE_X				( RES_X - RAQUETTE_W ) / 2	// abscisse de dpart de la raquette
#define RAQUETTE_Y				400							// ordonne de la raquette
#define BALL_W					16							// largeur de la balle
#define BALL_H					16							// hauteur de la balle
#define BALL_X					( RES_X - BALL_W ) / 2		// abscisse de dpart de la balle
#define BALL_Y					RAQUETTE_Y - BALL_H			// ordonne de dpart de la raquette
#define BRIK_W					32							// largeur d'une brique
#define BRIK_H					16							// hauteur d'une brique
#define BRIK_X					32							// abscisse de la premire brique en haut  gauche
#define BRIK_Y					60							// ordonne de la premire brique en haut  gauche
#define DECOR_W					RES_X						// largeur du dcor du score
#define DECOR_H					50							// hauteur du dcor du score
#define NUMBER_W				40							// largeur d'un nombre
#define NUMBER_H				40							// hauteur d'un nombre
#define LEVEL_X					120							// abscisse de l'endroit o est not le niveau
#define LEVEL_Y					7							// ordonne de l'endroit o est not le niveau
#define SCORE_X					380							// abscisse de l'endroit o est not le score
#define SCORE_Y					7							// ordonne de l'endroit o est not le score
#define LIFE_X					16							// abscisse de la premire vie
#define LIFE_Y					460							// ordonne de la premire vie
#define LIFE_W					32							// largeur d'une vie
#define LIFE_H					8							// hauteur d'une vie
#define LIFE_OFFSET				64							// espace entre 2 vies
#define LETTER_W				32							// largeur d'une lettre
#define LETTER_H				32							// hauteur d'une lettre
#define CURSOR_W				32							// largeur du curseur
#define CURSOR_H				21							// hauteur du curseur
#define NEWGAME_X				64							// abscisse de "New Game"
#define NEWGAME_Y				164							// ordonne de "New Game"
#define LOADGAME_X				64							// abscisse de "Load Game"
#define LOADGAME_Y				204							// ordonne de "Load Game"
#define SAVEGAME_X				64							// abscisse de "Save Game"
#define SAVEGAME_Y				244							// ordonne de "Save Game"
#define OPTIONS_X				64							// abscisse de "Options"
#define OPTIONS_Y				284							// ordonne de "Options"
#define HALLOFFAMES_X			64							// abscisse de "Hall of fames"
#define HALLOFFAMES_Y			324							// ordonne de "Hall of fames"
#define EXIT_X					64							// abscisse de "Exit"
#define EXIT_Y					364							// ordonne de "Exit"
#define OPTIONS_FULLSCREEN_X	64							// abscisse de "Full Screen "
#define OPTIONS_FULLSCREEN_Y	164							// ordonne de "Full Screen "
#define OPTIONS_SOUNDS_X		64							// abscisse de "Sounds "
#define OPTIONS_SOUNDS_Y		204							// ordonne de "Sounds "
#define OPTIONS_MUSIC_X			64							// abscisse de "Music "
#define OPTIONS_MUSIC_Y			244							// ordonne de "Music "
#define OPTIONS_SPEED_X			64							// abscisse de "Speed "
#define OPTIONS_SPEED_Y			284							// ordonne de "Speed "
#define OPTIONS_CONTROL_X		64							// abscisse de "Control "
#define OPTIONS_CONTROL_Y		324							// ordonne de "Control "
#define OPTIONS_QUIT_X			64							// abscisse de "Back to main menu"
#define OPTIONS_QUIT_Y			364							// ordonne de "Back to main menu"
#define TITLE_W					331							// largeur du titre "Bricks!"
#define TITLE_H					88							// hauteur du titre "Bricks!"
#define TITLE_X					( RES_X - TITLE_W ) / 2		// abscisse du titre "Bricks!"
#define TITLE_Y					10							// ordonne du titre "Bricks!"
#define SLOT1_X					64							// abscisse du slot1
#define SLOT2_X					64							// abscisse du slot2
#define SLOT3_X					64							// abscisse du slot3
#define SLOT4_X					64							// abscisse du slot4
#define SLOT5_X					64							// abscisse du slot5
#define SLOT6_X					64							// abscisse du slot6
#define SLOT7_X					64							// abscisse du slot7
#define SLOT8_X					64							// abscisse du slot8
#define SLOT1_Y					100							// ordonne du slot1
#define SLOT2_Y					140							// ordonne du slot2
#define SLOT3_Y					180							// ordonne du slot3
#define SLOT4_Y					220							// ordonne du slot4
#define SLOT5_Y					260							// ordonne du slot5
#define SLOT6_Y					300							// ordonne du slot6
#define SLOT7_Y					340							// ordonne du slot7
#define SLOT8_Y					380							// ordonne du slot8
#define LOADGAME_QUIT_X			64							// abscisse du "Back to main menu"
#define LOADGAME_QUIT_Y			420							// ordonne du "Back to main menu"
#define SAVEGAME_QUIT_X			64							// abscisse du "Back to main menu"
#define SAVEGAME_QUIT_Y			420							// ordonne du "Back to main menu"
#define HALLOFFAMES_TITLE_X		(RES_X-LETTER_W*13)/2		// abscisse du titre 'hall of fames'
#define HALLOFFAMES_TITLE_Y		100							// ordonne du titre 'hall of fames'
#define HALLOFFAMES_NAME_X		1							// abscisse du 1er nom
#define HALLOFFAMES_NAME_Y		140							// ordonne du 1er nom
#define HALLOFFAMES_SCORE_X		448							// abscisse du 1er score
#define HALLOFFAMES_SCORE_Y		140							// ordonne du 1er score


#endif //__SIZES_H
