/* sound.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <dsound.h>
#include "main.h"
#include "dsutil.h"
#include "resource.h"
#include "_error.h"


LPDIRECTSOUND g_lpDS = NULL;				// Objet DirectSound
LPDIRECTSOUNDBUFFER g_lpDSBBounce = NULL;	// Buffer contenant le son du rebond
LPDIRECTSOUNDBUFFER g_lpDDSBallLost = NULL;	// Le son ball lost
BOOL g_bSounds = TRUE;						// Jeu muet?


// Initialisation de DirectSound
BOOL DSInit()
{
	HRESULT		hr;		//The return result
	
	// Create DirectSound.
	hr = DirectSoundCreate( NULL, &g_lpDS, NULL );
	if(!DSCheck(hr, "DSInit : DirectSoundCreate"))
		return FALSE;
	
	// Set cooperative level.
	hr = g_lpDS->SetCooperativeLevel( g_hWnd, DSSCL_PRIORITY );
	if(!DSCheck(hr, "DSInit : SetCooperativeLevel"))
		return FALSE;
	
	return TRUE;
}


// Fermeture de DirectSound
void DSClose()
{
	// Dtruit les objets
	if( g_lpDSBBounce )
		g_lpDSBBounce->Release();
	if( g_lpDDSBallLost )
		g_lpDDSBallLost->Release();
	if( g_lpDS )
		g_lpDS->Release();
}


// Charge tous les sons
BOOL LoadSounds()
{
	// Le rebond
	g_lpDSBBounce = DSLoadWave( MAKEINTRESOURCE(IDR_BOUNCE) );
	if( g_lpDSBBounce == NULL )
	{
		Error("LoadSounds : IDR_BOUNCE");
		return FALSE;
	}
	
	// Ball Lost
	g_lpDDSBallLost = DSLoadWave( MAKEINTRESOURCE(IDR_BALLLOST) );
	if( g_lpDDSBallLost == NULL )
	{
		Error("LoadSounds : IDR_BALLLOST");
		return FALSE;
	}
	
	return TRUE;
}


// Joue le son du rebond
void PlayBounce()
{
	if( g_bSounds )
	{
		if(!DSPlay( g_lpDSBBounce ))
			Error("PlayBounce");
	}
}


// Joue le son de la balle sortie de l'cran
void PlayBallLost()
{
	if( g_bSounds )
	{
		if(!DSPlay( g_lpDDSBallLost ))
			Error("PlayBallLost");
	}
}


// Joue le son "niveau suivant"
void PlayNextLevel()
{
	if( g_bSounds )
	{
	}
}
