/* sprites.cpp */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <ddraw.h>
#include "resource.h"
#include "ddutil.h"


// Les cinq briques diffrentes
LPDIRECTDRAWSURFACE g_lpDDSBrik[5] = { NULL, NULL, NULL, NULL, NULL };
// Les nombres de 0  9 (pour l'affichage du score)
LPDIRECTDRAWSURFACE g_lpDDSNumber[10] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };
// La raquette
LPDIRECTDRAWSURFACE g_lpDDSRaquette = NULL;
// L'cran de pause
LPDIRECTDRAWSURFACE g_lpDDSPause = NULL;
// L'cran GameOver
LPDIRECTDRAWSURFACE g_lpDDSGameOver = NULL;
// Le dcors du score
LPDIRECTDRAWSURFACE g_lpDDSScore = NULL;
// La balle
LPDIRECTDRAWSURFACE g_lpDDSBall = NULL;
// Une vie
LPDIRECTDRAWSURFACE g_lpDDSLife = NULL;
// Les lettres
LPDIRECTDRAWSURFACE g_lpDDSLetter[26] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };
// le caractere underscore ('_')
LPDIRECTDRAWSURFACE g_lpDDSUnderscore = NULL;
// Le curseur
LPDIRECTDRAWSURFACE g_lpDDSCursor = NULL;
// Le titre Bricks !
LPDIRECTDRAWSURFACE g_lpDDSBricks = NULL;


BOOL LoadLetters()
{
	int IDB_LETTERS[26] = { IDB_A,
							IDB_B,
							IDB_C,
							IDB_D,
							IDB_E,
							IDB_F,
							IDB_G,
							IDB_H,
							IDB_I,
							IDB_J,
							IDB_K,
							IDB_L,
							IDB_M,
							IDB_N,
							IDB_O,
							IDB_P,
							IDB_Q,
							IDB_R,
							IDB_S,
							IDB_T,
							IDB_U,
							IDB_V,
							IDB_W,
							IDB_X,
							IDB_Y,
							IDB_Z
	};
	for( int i = 0 ; i < 26 ; i++ )
	{
		g_lpDDSLetter[i] = DDLoadBitmap( MAKEINTRESOURCE(IDB_LETTERS[i]), 0, 0 );
		if( g_lpDDSLetter[i] == NULL )
			return FALSE;
	}
	
	// underscore
	g_lpDDSUnderscore = DDLoadBitmap( MAKEINTRESOURCE(IDB_UNDERSCORE), 0, 0 );
	if(g_lpDDSUnderscore == NULL)
		return FALSE;
	
	return TRUE;
}


void UnloadLetters()
{
	for( int i = 0 ; i < 26 ; i++ )
	{
		if( g_lpDDSLetter[i] )
			g_lpDDSLetter[i]->Release();
	}
	if( g_lpDDSUnderscore )
		g_lpDDSUnderscore->Release();
}


// Charge tous les sprites
BOOL LoadSprites()
{
	// Briques
	int IDB_BRIK[5] = { IDB_BRIK1, IDB_BRIK2, IDB_BRIK3, IDB_BRIK4, IDB_BRIK5 };
	for(int i = 0 ; i < 5 ; i++ )
	{
		g_lpDDSBrik[i] = DDLoadBitmap( MAKEINTRESOURCE(IDB_BRIK[i]), 0, 0 );
		if(g_lpDDSBrik[i] == NULL)
			return FALSE;
	}
	
	// Nombres
	int IDB_NUMBER[10] = { IDB_NUMBER0, IDB_NUMBER1, IDB_NUMBER2, IDB_NUMBER3, IDB_NUMBER4, IDB_NUMBER5, IDB_NUMBER6, IDB_NUMBER7, IDB_NUMBER8, IDB_NUMBER9 };
	for(i = 0 ; i < 10 ; i++ )
	{
		g_lpDDSNumber[i] = DDLoadBitmap( MAKEINTRESOURCE(IDB_NUMBER[i]), 0, 0 );
		if(g_lpDDSNumber[i] == NULL)
			return FALSE;
	}
	
	// Raquette
	g_lpDDSRaquette = DDLoadBitmap( MAKEINTRESOURCE(IDB_RAQUETTE), 0, 0 );
	if(g_lpDDSRaquette == NULL)
		return FALSE;
	
	// Pause
	g_lpDDSPause = DDLoadBitmap( MAKEINTRESOURCE(IDB_PAUSE), 0, 0 );
	if(g_lpDDSPause == NULL)
		return FALSE;
	
	// GameOver
	g_lpDDSGameOver = DDLoadBitmap( MAKEINTRESOURCE(IDB_GAMEOVER), 0, 0 );
	if(g_lpDDSGameOver == NULL)
		return FALSE;
	
	// Dcors du score
	g_lpDDSScore = DDLoadBitmap( MAKEINTRESOURCE(IDB_SCORE), 0, 0 );
	if(g_lpDDSScore == NULL)
		return FALSE;
	
	// Balle
	g_lpDDSBall = DDLoadBitmap( MAKEINTRESOURCE(IDB_BALL), 0, 0 );
	if(g_lpDDSBall == NULL)
		return FALSE;
	
	// Une vie
	g_lpDDSLife = DDLoadBitmap( MAKEINTRESOURCE(IDB_LIFE), 0, 0 );
	if(g_lpDDSLife == NULL)
		return FALSE;
	
	// Lettres
	if(!LoadLetters())
		return FALSE;
	
	// Le curseur
	g_lpDDSCursor = DDLoadBitmap( MAKEINTRESOURCE(IDB_CURSOR), 0, 0 );
	if(g_lpDDSCursor == NULL)
		return FALSE;
	
	// Le titre
	g_lpDDSBricks = DDLoadBitmap( MAKEINTRESOURCE(IDB_BRICKS), 0, 0 );
	if(g_lpDDSBricks == NULL)
		return FALSE;

	return TRUE;
}


void UnloadSprites()
{
	for( int i = 0 ; i < 5 ; i++ )
	{
		if( g_lpDDSBrik[i] )
			g_lpDDSBrik[i]->Release();
	}
	for( i = 0 ; i < 10 ; i++ )
	{
		if( g_lpDDSNumber[i] )
			g_lpDDSNumber[i]->Release();
	}
	if( g_lpDDSRaquette )
		g_lpDDSRaquette->Release();
	if( g_lpDDSPause )
		g_lpDDSPause->Release();
	if( g_lpDDSGameOver )
		g_lpDDSGameOver->Release();
	if( g_lpDDSScore )
		g_lpDDSScore->Release();
	if( g_lpDDSBall )
		g_lpDDSBall->Release();
	if( g_lpDDSLife )
		g_lpDDSLife->Release();
	UnloadLetters();
	if( g_lpDDSCursor )
		g_lpDDSCursor->Release();
	if( g_lpDDSBricks )
		g_lpDDSBricks->Release();
}
