/* winutil.c */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Bricks!                                  Copyright (C) 2001, AnTiKoNs *
 *---------/                                                             *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * The author of this program may be contacted at antikons@ifrance.com   *
 *                                                                       *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <windows.h>
#include <windowsx.h>


//Met la taille de la fenetre  640*480 et centre celle-ci
void SizeAndCenterWindow( HWND hwnd, int clientWidth, int clientHeight )
{
	RECT rc;
	
	// Set the desired size for the *client* area of the window.
	SetRect( &rc, 0, 0, clientWidth, clientHeight );
	
	// Adjust that to a size that includes the border, etc.
	AdjustWindowRect( &rc,
			GetWindowStyle( hwnd ),	// style of our main window
			GetMenu( hwnd ) != NULL);	// does the window have a menu?
	
	// Adjust the window to the new size and center it
	MoveWindow( hwnd,
				(GetSystemMetrics( SM_CXSCREEN ) - rc.right - rc.left) / 2,
				(GetSystemMetrics( SM_CYSCREEN ) - rc.bottom - rc.top) / 2,
                rc.right - rc.left,
                rc.bottom - rc.top,
                TRUE );
}
